/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.buzzier_bees.common.entity.animal;

import com.teamabnormals.buzzier_bees.common.entity.ai.goal.BearAttackPlayerGoal;
import com.teamabnormals.buzzier_bees.common.entity.ai.goal.BearHurtByTargetGoal;
import com.teamabnormals.buzzier_bees.common.entity.ai.goal.BearMeleeAttackGoal;
import com.teamabnormals.buzzier_bees.common.entity.ai.goal.BearPanicGoal;
import com.teamabnormals.buzzier_bees.core.other.tags.BBItemTags;
import com.teamabnormals.buzzier_bees.core.registry.BBEntityTypes;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class GrizzlyBearEntity
extends Animal {
    private static final EntityDataAccessor<Boolean> EATING = SynchedEntityData.m_135353_(GrizzlyBearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Predicate<ItemEntity> TRUSTED_TARGET_SELECTOR = entity -> !entity.m_32063_() && entity.m_6084_();
    private int warningSoundTicks;
    public int eatTicks;

    public GrizzlyBearEntity(EntityType<? extends GrizzlyBearEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_21553_(true);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BearMeleeAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new BearPanicGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new FindItemsGoal());
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new BearHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new BearAttackPlayerGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Fox.class, 10, true, true, null));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 6.0);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(BBItemTags.GRIZZLY_BEAR_FOOD);
    }

    protected SoundEvent m_7515_() {
        return this.m_6162_() ? SoundEvents.f_12281_ : SoundEvents.f_12280_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12283_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12282_;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12284_, 0.15f, 1.0f);
    }

    public void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.m_5496_(SoundEvents.f_12285_, 1.0f, this.m_6100_());
            this.warningSoundTicks = 40;
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(EATING, (Object)false);
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob ageable) {
        return (AgeableMob)((EntityType)BBEntityTypes.GRIZZLY_BEAR.get()).m_20615_((Level)world);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == Items.f_42715_) {
            this.setEating(true);
        } else if (stack.m_41720_() == Items.f_42716_) {
            this.setEating(false);
        }
        return super.m_6071_(player, hand);
    }

    private boolean canEatItem(ItemStack itemStackIn) {
        return itemStackIn.m_41720_().m_41472_() && this.m_5448_() == null && this.f_19861_;
    }

    public boolean m_7066_(ItemStack itemstackIn) {
        EquipmentSlot equipmentslottype = Mob.m_147233_((ItemStack)itemstackIn);
        if (!this.m_6844_(equipmentslottype).m_41619_()) {
            return false;
        }
        return equipmentslottype == EquipmentSlot.MAINHAND && super.m_7066_(itemstackIn);
    }

    public boolean m_7252_(ItemStack stack) {
        Item item = stack.m_41720_();
        ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
        return itemstack.m_41619_() || this.eatTicks > 0 && item.m_41472_() && !itemstack.m_41720_().m_41472_();
    }

    private void spitOutItem(ItemStack stackIn) {
        if (!stackIn.m_41619_() && !this.f_19853_.f_46443_) {
            ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_() + this.m_20154_().f_82479_, this.m_20186_() + 1.0, this.m_20189_() + this.m_20154_().f_82481_, stackIn);
            itementity.m_32010_(40);
            itementity.m_32052_(this.m_20148_());
            this.m_5496_(SoundEvents.f_11952_, 1.0f, 1.0f);
            this.f_19853_.m_7967_((Entity)itementity);
        }
    }

    private void spawnItem(ItemStack stackIn) {
        ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), stackIn);
        this.f_19853_.m_7967_((Entity)itementity);
    }

    protected void m_7581_(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.m_32055_();
        if (this.m_7252_(itemstack)) {
            int i = itemstack.m_41613_();
            if (i > 1) {
                this.spawnItem(itemstack.m_41620_(i - 1));
            }
            this.spitOutItem(this.m_6844_(EquipmentSlot.MAINHAND));
            this.m_21053_(itemEntity);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41620_(1));
            this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
            this.m_7938_((Entity)itemEntity, itemstack.m_41613_());
            itemEntity.m_146870_();
            this.eatTicks = 0;
        }
    }

    public void m_8107_() {
        if (!this.f_19853_.f_46443_ && this.m_6084_() && this.m_6142_()) {
            ++this.eatTicks;
            ItemStack stack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (this.canEatItem(stack)) {
                if (this.eatTicks > 600) {
                    ItemStack returnStack = stack.m_41671_(this.f_19853_, (LivingEntity)this);
                    if (!returnStack.m_41619_()) {
                        this.m_8061_(EquipmentSlot.MAINHAND, returnStack);
                    }
                    this.eatTicks = 0;
                    this.setEating(false);
                } else if (this.eatTicks > 560 && this.f_19796_.m_188501_() < 0.1f) {
                    this.setEating(true);
                    this.m_5496_(this.m_7866_(stack), 1.0f, 1.0f);
                    this.f_19853_.m_7605_((Entity)this, (byte)45);
                }
            }
        }
        super.m_8107_();
    }

    public boolean isEating() {
        return (Boolean)this.f_19804_.m_135370_(EATING);
    }

    public void setEating(boolean eating) {
        this.f_19804_.m_135381_(EATING, (Object)eating);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)((int)this.m_21051_(Attributes.f_22281_).m_22135_()));
        if (flag) {
            this.m_19970_((LivingEntity)this, entityIn);
        }
        return flag;
    }

    protected float m_6108_() {
        return 0.98f;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (spawnDataIn == null) {
            spawnDataIn = new AgeableMob.AgeableMobGroupData(1.0f);
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    class FindItemsGoal
    extends Goal {
        public FindItemsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!GrizzlyBearEntity.this.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
                return false;
            }
            if (GrizzlyBearEntity.this.m_5448_() == null && GrizzlyBearEntity.this.m_21188_() == null) {
                if (GrizzlyBearEntity.this.m_217043_().m_188503_(10) != 0) {
                    return false;
                }
                List list = GrizzlyBearEntity.this.f_19853_.m_6443_(ItemEntity.class, GrizzlyBearEntity.this.m_20191_().m_82377_(8.0, 8.0, 8.0), TRUSTED_TARGET_SELECTOR);
                return !list.isEmpty() && GrizzlyBearEntity.this.m_6844_(EquipmentSlot.MAINHAND).m_41619_();
            }
            return false;
        }

        public void m_8037_() {
            List list = GrizzlyBearEntity.this.f_19853_.m_6443_(ItemEntity.class, GrizzlyBearEntity.this.m_20191_().m_82377_(8.0, 8.0, 8.0), TRUSTED_TARGET_SELECTOR);
            ItemStack itemstack = GrizzlyBearEntity.this.m_6844_(EquipmentSlot.MAINHAND);
            if (itemstack.m_41619_() && !list.isEmpty()) {
                GrizzlyBearEntity.this.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
            }
        }

        public void m_8056_() {
            List list = GrizzlyBearEntity.this.f_19853_.m_6443_(ItemEntity.class, GrizzlyBearEntity.this.m_20191_().m_82377_(8.0, 8.0, 8.0), TRUSTED_TARGET_SELECTOR);
            if (!list.isEmpty()) {
                GrizzlyBearEntity.this.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
            }
        }
    }
}

