/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.charmofundying.common;

import com.google.common.collect.ImmutableSet;
import com.illusivesoulworks.charmofundying.common.ITotemEffectProvider;
import com.illusivesoulworks.charmofundying.common.VanillaTotemEffectProvider;
import com.illusivesoulworks.charmofundying.common.integration.BMEnchantedTotemEffectProvider;
import com.illusivesoulworks.charmofundying.platform.Services;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.world.item.Item;

public class TotemProviders {
    public static Predicate<Item> IS_TOTEM = new Predicate<Item>(){

        @Override
        public boolean test(Item item) {
            return EFFECT_PROVIDERS.containsKey(Services.PLATFORM.getRegistryName(item));
        }
    };
    private static final Map<String, ITotemEffectProvider> EFFECT_PROVIDERS = new ConcurrentHashMap<String, ITotemEffectProvider>();

    public static void init() {
        EFFECT_PROVIDERS.put("minecraft:totem_of_undying", new VanillaTotemEffectProvider());
        if (Services.PLATFORM.isModLoaded("biomemakeover")) {
            EFFECT_PROVIDERS.put("biomemakeover:enchanted_totem", new BMEnchantedTotemEffectProvider());
        }
    }

    public static Set<String> getItems() {
        return ImmutableSet.copyOf(EFFECT_PROVIDERS.keySet());
    }

    public static Optional<ITotemEffectProvider> getEffectProvider(Item item) {
        return Optional.ofNullable(EFFECT_PROVIDERS.get(Services.PLATFORM.getRegistryName(item)));
    }

    public static void putEffectProvider(String key, ITotemEffectProvider provider) {
        EFFECT_PROVIDERS.put(key, provider);
    }
}

