/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import team.tnt.collectoralbum.common.AlbumStats;
import team.tnt.collectoralbum.common.ICardCategory;
import team.tnt.collectoralbum.common.init.CardCategoryRegistry;
import team.tnt.collectoralbum.common.item.CardRarity;
import team.tnt.collectoralbum.common.item.ICard;
import team.tnt.collectoralbum.common.menu.AlbumMenu;
import team.tnt.collectoralbum.network.Networking;
import team.tnt.collectoralbum.network.packet.RequestAlbumPagePacket;

public class AlbumScreen
extends AbstractContainerScreen<AlbumMenu> {
    private static final ResourceLocation TITLE = new ResourceLocation("collectorsalbum", "textures/screen/album_title.png");
    private static final ResourceLocation BACKGROUND = new ResourceLocation("collectorsalbum", "textures/screen/album.png");
    private static final ResourceLocation ARROW_LEFT = new ResourceLocation("collectorsalbum", "textures/screen/album_previous.png");
    private static final ResourceLocation ARROW_RIGHT = new ResourceLocation("collectorsalbum", "textures/screen/album_next.png");
    private static final MutableComponent TEXT_HEADER = Component.m_237115_((String)"text.collectorsalbum.album.header").m_130940_(ChatFormatting.BOLD);
    private static final MutableComponent TEXT_CATEGORIES = Component.m_237115_((String)"text.collectorsalbum.album.categories").m_130940_(ChatFormatting.UNDERLINE);
    private static final MutableComponent TEXT_RARITIES = Component.m_237115_((String)"text.collectorsalbum.album.rarities").m_130940_(ChatFormatting.UNDERLINE);
    private static final Function<Integer, MutableComponent> TEXT_POINTS = points -> Component.m_237110_((String)"text.collectorsalbum.album.points", (Object[])new Object[]{points});
    private static final BiFunction<Integer, Integer, MutableComponent> TEXT_TOTAL_CARDS = (cards, total) -> Component.m_237110_((String)"text.collectorsalbum.album.total_cards", (Object[])new Object[]{cards, total});
    private final int pageIndex;
    private AlbumStats stats;

    public AlbumScreen(AlbumMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
        this.f_97726_ = 306;
        this.f_97727_ = 257;
        this.pageIndex = ((AlbumMenu)this.f_97732_).isTitle() ? 0 : ((AlbumMenu)this.f_97732_).getCategoryIndex();
    }

    protected void m_7856_() {
        ArrowWidget widget;
        super.m_7856_();
        if (this.pageIndex > 0) {
            widget = (ArrowWidget)this.m_142416_((GuiEventListener)new ArrowWidget(this.f_97735_ + 18, this.f_97736_ + 5, 16, 16, ARROW_LEFT));
            widget.setOnClickResponder(this::clickPrevPage);
        }
        if (this.pageIndex < CardCategoryRegistry.getCount()) {
            widget = (ArrowWidget)this.m_142416_((GuiEventListener)new ArrowWidget(this.f_97735_ + 265, this.f_97736_ + 4, 16, 16, ARROW_RIGHT));
            widget.setOnClickResponder(this::clickNextPage);
        }
        this.stats = ((AlbumMenu)this.f_97732_).getContainer().getStats();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 68 || keyCode == 262) {
            this.changePage(1);
            return true;
        }
        if (keyCode == 65 || keyCode == 263) {
            this.changePage(-1);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected void m_7286_(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)(((AlbumMenu)this.f_97732_).isTitle() ? TITLE : BACKGROUND));
        Matrix4f pose = poseStack.m_85850_().m_85861_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_85982_(pose, (float)this.f_97735_, (float)this.f_97736_, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        bufferBuilder.m_85982_(pose, (float)this.f_97735_, (float)(this.f_97736_ + this.f_97727_), 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        bufferBuilder.m_85982_(pose, (float)(this.f_97735_ + this.f_97726_), (float)(this.f_97736_ + this.f_97727_), 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        bufferBuilder.m_85982_(pose, (float)(this.f_97735_ + this.f_97726_), (float)this.f_97736_, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        if (((AlbumMenu)this.f_97732_).isTitle()) {
            int headerWidth = this.f_96547_.m_92852_((FormattedText)TEXT_HEADER);
            this.f_96547_.m_92889_(poseStack, (Component)TEXT_HEADER, 20.0f + (float)(130 - headerWidth) / 2.0f, 13.0f, 8150349);
            this.f_96547_.m_92889_(poseStack, (Component)TEXT_RARITIES, 27.0f, 55.0f, 8150349);
            int i = 0;
            Map<CardRarity, Integer> byRarity = this.stats.getCardsByRarity();
            for (CardRarity rarity : CardRarity.values()) {
                int value = byRarity.getOrDefault((Object)rarity, 0);
                String name = rarity.name();
                String pct = Math.round((float)value / (float)this.stats.getCardsCollected() * 100.0f) + "%";
                String text = name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase() + ": " + pct;
                this.f_96547_.m_92883_(poseStack, text, 30.0f, (float)(67 + i++ * 10), 8150349);
            }
            int collected = this.stats.getCardsCollected();
            int total = this.stats.getTotalCards();
            this.f_96547_.m_92889_(poseStack, (Component)TEXT_TOTAL_CARDS.apply(collected, total), 27.0f, 35.0f, 8150349);
            int points = this.stats.getPoints();
            this.f_96547_.m_92889_(poseStack, (Component)TEXT_POINTS.apply(points), 27.0f, (float)(80 + i * 10), 8150349);
            this.f_96547_.m_92889_(poseStack, (Component)TEXT_CATEGORIES, 164.0f, 35.0f, 8150349);
            int j = 0;
            Map<ICardCategory, List<ICard>> map = this.stats.getCardsByCategory();
            for (ICardCategory category : (ICardCategory[])CardCategoryRegistry.getValues().stream().sorted().toArray(ICardCategory[]::new)) {
                int value = Optional.ofNullable(map.get(category)).map(List::size).orElse(0);
                Component displayName = category.getTranslatedName();
                String count = value + " / " + category.getCapacity();
                String text = displayName.getString() + " - " + count;
                this.f_96547_.m_92883_(poseStack, text, 167.0f, (float)(47 + j++ * 10), 8150349);
            }
            return;
        }
        for (Slot slot : ((AlbumMenu)this.f_97732_).f_38839_) {
            if (!(slot instanceof AlbumMenu.CardSlot)) continue;
            AlbumMenu.CardSlot cardSlot = (AlbumMenu.CardSlot)slot;
            int cardNumber = cardSlot.getCardNumber();
            String text = "#" + cardNumber;
            this.f_96547_.m_92883_(poseStack, text, (float)slot.f_40220_ + (float)(18 - this.f_96547_.m_92895_(text)) / 2.0f - 1.0f, (float)(slot.f_40221_ + 18), 8150349);
        }
        ICardCategory category = ((AlbumMenu)this.f_97732_).getCategory();
        MutableComponent component = Component.m_237113_((String)category.getTranslatedName().getString()).m_130940_(ChatFormatting.ITALIC);
        this.f_96547_.m_92889_(poseStack, (Component)component, 40.0f, 10.0f, 8150349);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    protected void clickPrevPage(ArrowWidget widget) {
        this.changePage(-1);
    }

    protected void clickNextPage(ArrowWidget widget) {
        this.changePage(1);
    }

    protected void changePage(int indexOffset) {
        int nextIndex = this.pageIndex + indexOffset;
        if (nextIndex < 0 || nextIndex > CardCategoryRegistry.getCount()) {
            return;
        }
        ICardCategory category = nextIndex == 0 ? null : CardCategoryRegistry.byIndex(nextIndex - 1);
        Networking.dispatchServerPacket(new RequestAlbumPagePacket(category));
    }

    protected static final class ArrowWidget
    extends AbstractWidget {
        private final ResourceLocation location;
        private ClickResponder clickResponder = widget -> {};

        public ArrowWidget(int x, int y, int width, int height, ResourceLocation location) {
            super(x, y, width, height, CommonComponents.f_237098_);
            this.location = location;
        }

        public void setOnClickResponder(ClickResponder responder) {
            this.clickResponder = responder;
        }

        public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.location);
            Matrix4f pose = poseStack.m_85850_().m_85861_();
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferBuilder = tesselator.m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferBuilder.m_85982_(pose, (float)this.f_93620_, (float)this.f_93621_, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
            bufferBuilder.m_85982_(pose, (float)this.f_93620_, (float)(this.f_93621_ + this.f_93618_), 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
            bufferBuilder.m_85982_(pose, (float)(this.f_93620_ + this.f_93619_), (float)(this.f_93621_ + this.f_93618_), 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
            bufferBuilder.m_85982_(pose, (float)(this.f_93620_ + this.f_93619_), (float)this.f_93621_, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
            tesselator.m_85914_();
        }

        public void m_5716_(double mouseX, double mouseY) {
            this.clickResponder.onClick(this);
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }

        @FunctionalInterface
        static interface ClickResponder {
            public void onClick(ArrowWidget var1);
        }
    }
}

