/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.common;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import team.tnt.collectoralbum.common.ICardCategory;
import team.tnt.collectoralbum.common.container.AlbumContainer;
import team.tnt.collectoralbum.common.init.CardCategoryRegistry;
import team.tnt.collectoralbum.common.init.CardRegistry;
import team.tnt.collectoralbum.common.item.CardRarity;
import team.tnt.collectoralbum.common.item.ICard;

public class AlbumStats {
    private final int cardsCollected;
    private final int totalCards;
    private final Map<CardRarity, Integer> cardsByRarity = new EnumMap<CardRarity, Integer>(CardRarity.class);
    private final Map<ICardCategory, List<ICard>> cardsByCategory;
    private final int points;

    public AlbumStats(AlbumContainer container) {
        this.cardsByCategory = new HashMap<ICardCategory, List<ICard>>();
        int collected = 0;
        int pointCounter = 0;
        for (ICardCategory category : CardCategoryRegistry.getValues()) {
            SimpleContainer categoryContainer = container.forCategory(category);
            for (int i = 0; i < categoryContainer.m_6643_(); ++i) {
                ItemStack stack = categoryContainer.m_8020_(i);
                Item item = stack.m_41720_();
                if (!(item instanceof ICard)) continue;
                ICard card = (ICard)item;
                ++collected;
                this.cardsByCategory.computeIfAbsent(category, k -> new ArrayList()).add(card);
                CardRarity rarity = card.getCardRarity();
                this.increaseCounter(this.cardsByRarity, rarity);
                pointCounter += rarity.getValue();
            }
        }
        this.cardsCollected = collected;
        this.totalCards = CardRegistry.count();
        this.points = pointCounter;
    }

    private AlbumStats(int cards, int points, Map<ICardCategory, List<ICard>> byCategory) {
        this.cardsCollected = cards;
        this.totalCards = CardRegistry.count();
        this.points = points;
        this.cardsByCategory = byCategory;
    }

    public static AlbumStats createSimplifiedWithoutContainer(ItemStack album) {
        CompoundTag tag = album.m_41784_();
        CompoundTag inventories = tag.m_128469_("inventories");
        int cardCounter = 0;
        int pointCounter = 0;
        HashMap<ICardCategory, List<ICard>> byCategory = new HashMap<ICardCategory, List<ICard>>();
        for (ICardCategory category : CardCategoryRegistry.getValues()) {
            ListTag slots = inventories.m_128437_(category.getId().toString(), 10);
            for (int i = 0; i < slots.size(); ++i) {
                CompoundTag slotDef = slots.m_128728_(i);
                ItemStack item = ItemStack.m_41712_((CompoundTag)slotDef.m_128469_("itemStack"));
                Item item2 = item.m_41720_();
                if (!(item2 instanceof ICard)) continue;
                ICard card = (ICard)item2;
                ++cardCounter;
                pointCounter += card.getCardRarity().getValue();
                byCategory.computeIfAbsent(category, k -> new ArrayList()).add(card);
            }
        }
        return new AlbumStats(cardCounter, pointCounter, byCategory);
    }

    public int getCardsCollected() {
        return this.cardsCollected;
    }

    public int getTotalCards() {
        return this.totalCards;
    }

    public Map<CardRarity, Integer> getCardsByRarity() {
        return this.cardsByRarity;
    }

    public Map<ICardCategory, List<ICard>> getCardsByCategory() {
        return this.cardsByCategory;
    }

    public int getPoints() {
        return this.points;
    }

    private <K> void increaseCounter(Map<K, Integer> map, K key) {
        int value = map.computeIfAbsent(key, k -> 0) + 1;
        map.put(key, value);
    }
}

