/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.common.container;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import team.tnt.collectoralbum.common.AlbumStats;
import team.tnt.collectoralbum.common.CardCategoryIndexPool;
import team.tnt.collectoralbum.common.ICardCategory;
import team.tnt.collectoralbum.common.init.CardCategoryRegistry;

public class AlbumContainer
extends SimpleContainer {
    private final Map<ICardCategory, SimpleContainer> inventoriesByCategory = new HashMap<ICardCategory, SimpleContainer>();

    public AlbumContainer(ItemStack stack) {
        super(new ItemStack[0]);
        CompoundTag tag = stack.m_41784_();
        CompoundTag inventories = tag.m_128469_("inventories");
        CardCategoryRegistry.getValues().forEach(category -> {
            SimpleContainer container = new SimpleContainer(category.getCapacity());
            container.m_19164_(ref -> this.m_6596_());
            this.inventoriesByCategory.put((ICardCategory)category, container);
        });
        for (ICardCategory category2 : CardCategoryRegistry.getValues()) {
            ListTag slots = inventories.m_128437_(category2.getId().toString(), 10);
            for (int i = 0; i < slots.size(); ++i) {
                CompoundTag slotDef = slots.m_128728_(i);
                int slotIndex = slotDef.m_128451_("slotIndex");
                CompoundTag itemTag = slotDef.m_128469_("itemStack");
                ItemStack item = ItemStack.m_41712_((CompoundTag)itemTag);
                this.inventoriesByCategory.get(category2).m_6836_(slotIndex, item);
            }
        }
        this.m_19164_(new Listener(stack, this.inventoriesByCategory::get));
    }

    public SimpleContainer forCategory(ICardCategory category) {
        return this.inventoriesByCategory.get(category);
    }

    public int getCategoryIndexOffset(ICardCategory category) {
        return CardCategoryIndexPool.getIndexOffset(category);
    }

    public AlbumStats getStats() {
        return new AlbumStats(this);
    }

    private record Listener(ItemStack itemRef, Function<ICardCategory, SimpleContainer> containerFetcher) implements ContainerListener
    {
        public void m_5757_(Container invBasic) {
            CompoundTag tag = this.itemRef.m_41784_();
            CompoundTag inventoryTag = new CompoundTag();
            for (ICardCategory category : CardCategoryRegistry.getValues()) {
                ListTag listTag = new ListTag();
                SimpleContainer container = this.containerFetcher.apply(category);
                for (int i = 0; i < container.m_6643_(); ++i) {
                    ItemStack stack = container.m_8020_(i);
                    if (stack.m_41619_()) continue;
                    CompoundTag slotDef = new CompoundTag();
                    slotDef.m_128405_("slotIndex", i);
                    slotDef.m_128365_("itemStack", (Tag)stack.m_41739_(new CompoundTag()));
                    listTag.add((Object)slotDef);
                }
                inventoryTag.m_128365_(category.getId().toString(), (Tag)listTag);
            }
            tag.m_128365_("inventories", (Tag)inventoryTag);
            this.itemRef.m_41751_(tag);
        }
    }
}

