/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.common.init;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.resources.ResourceLocation;
import team.tnt.collectoralbum.common.CardCategory;
import team.tnt.collectoralbum.common.ICardCategory;

public class CardCategoryRegistry {
    private static final Map<ResourceLocation, ICardCategory> REGISTRY = new HashMap<ResourceLocation, ICardCategory>();
    public static final ICardCategory TOOLS = CardCategoryRegistry.internalRegister("tools", ChatFormatting.YELLOW);
    public static final ICardCategory ARMOR = CardCategoryRegistry.internalRegister("armor", ChatFormatting.BLUE);
    public static final ICardCategory MOBS = CardCategoryRegistry.internalRegister("mobs", ChatFormatting.RED);
    public static final ICardCategory NATURE = CardCategoryRegistry.internalRegister("nature", ChatFormatting.GREEN);
    public static final ICardCategory ITEMS = CardCategoryRegistry.internalRegister("items", ChatFormatting.WHITE);

    public static void register(ICardCategory category) {
        if (REGISTRY.put(category.getId(), category) != null) {
            throw new IllegalStateException("Duplicate card category: " + category.getId());
        }
    }

    public static ICardCategory getByKey(ResourceLocation key) {
        return REGISTRY.get(key);
    }

    public static Collection<ICardCategory> getValues() {
        return REGISTRY.values();
    }

    public static int getCount() {
        return REGISTRY.size();
    }

    public static ICardCategory byIndex(int index) {
        return REGISTRY.values().stream().filter(cat -> cat.getIndex() == index).findFirst().orElse(null);
    }

    private static ICardCategory internalRegister(String id, ChatFormatting formatting) {
        CardCategory category = new CardCategory(new ResourceLocation("collectorsalbum", id), formatting);
        CardCategoryRegistry.register(category);
        return category;
    }
}

