/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.common.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;
import team.tnt.collectoralbum.CollectorsAlbum;
import team.tnt.collectoralbum.common.CardCategoryIndexPool;
import team.tnt.collectoralbum.common.CardDefinition;
import team.tnt.collectoralbum.common.item.CardRarity;
import team.tnt.collectoralbum.common.item.ICard;
import team.tnt.collectoralbum.integration.IntegrationsHelper;

public class CardItem
extends Item
implements ICard {
    private static final String TEXT_CARD_NUMBER = "card.tooltip.number";
    private static final String TEXT_CARD_RARITY = "card.tooltip.rarity";
    private static final String TEXT_CARD_CATEGORY = "card.tooltip.category";
    private static final String TEXT_CARD_VALUE = "card.tooltip.value";
    private final CardDefinition card;
    private final CardRarity rarity;
    private final int cardNumber;

    public CardItem(CardRarity rarity, CardDefinition card) {
        super(new Item.Properties().m_41491_(CollectorsAlbum.TAB));
        this.card = card;
        this.rarity = rarity;
        this.cardNumber = CardCategoryIndexPool.getIndexOffset(card.category()) + card.cardNumber();
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return IntegrationsHelper.getCardCapabilityProvider(stack, nbt);
    }

    @Override
    public CardDefinition getCard() {
        return this.card;
    }

    @Override
    public CardRarity getCardRarity() {
        return this.rarity;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        CardItem cardItem = (CardItem)stack.m_41720_();
        CardDefinition definition = cardItem.getCard();
        MutableComponent numberComponent = Component.m_237113_((String)("#" + this.cardNumber)).m_130940_(ChatFormatting.YELLOW);
        MutableComponent categoryComponent = Component.m_237113_((String)definition.category().getTranslatedName().getString()).m_130940_(definition.category().getTooltipFormat());
        Component rarityComponent = this.rarity.getTranslatedName();
        MutableComponent valueComponent = Component.m_237113_((String)(this.rarity.getValue() + " pts")).m_130940_(ChatFormatting.WHITE);
        tooltipComponents.add((Component)Component.m_237110_((String)TEXT_CARD_NUMBER, (Object[])new Object[]{numberComponent}).m_130940_(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.m_237110_((String)TEXT_CARD_CATEGORY, (Object[])new Object[]{categoryComponent}).m_130940_(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.m_237110_((String)TEXT_CARD_RARITY, (Object[])new Object[]{rarityComponent}).m_130940_(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.m_237110_((String)TEXT_CARD_VALUE, (Object[])new Object[]{valueComponent}).m_130940_(ChatFormatting.GRAY));
    }
}

