/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.common.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import team.tnt.collectoralbum.CollectorsAlbum;
import team.tnt.collectoralbum.common.init.SoundRegistry;
import team.tnt.collectoralbum.data.packs.ICardDropProvider;
import team.tnt.collectoralbum.network.Networking;
import team.tnt.collectoralbum.network.packet.OpenCardScreenPacket;
import team.tnt.collectoralbum.server.OpenCardPackContextHolder;

public class CardPackItem
extends Item {
    private final ResourceLocation dropsProviderPath;

    public CardPackItem(ResourceLocation dropsProviderPath) {
        super(new Item.Properties().m_41491_(CollectorsAlbum.TAB));
        this.dropsProviderPath = dropsProviderPath;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 20;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity livingEntity) {
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            Optional<ICardDropProvider> optional = CollectorsAlbum.CARD_PACK_MANAGER.getProvider(this.dropsProviderPath);
            optional.ifPresent(provider -> {
                List<ItemStack> itemStacks = provider.provideDrops();
                OpenCardPackContextHolder.store(player, itemStacks);
                Networking.dispatchClientPacket(player, new OpenCardScreenPacket(itemStacks));
            });
            ItemCooldowns cooldowns = player.m_36335_();
            cooldowns.m_41524_(stack.m_41720_(), 10);
        } else {
            livingEntity.m_5496_((SoundEvent)SoundRegistry.OPEN.get(), 0.8f, 1.0f);
        }
        return stack;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        ItemCooldowns cooldowns = player.m_36335_();
        if (cooldowns.m_41519_(stack.m_41720_())) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        player.m_6672_(usedHand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }
}

