/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.data.boosts;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.tnt.collectoralbum.data.boosts.ActionType;
import team.tnt.collectoralbum.data.boosts.AlbumCardBoostCollection;
import team.tnt.collectoralbum.data.boosts.IAction;
import team.tnt.collectoralbum.data.boosts.OpType;
import team.tnt.collectoralbum.util.JsonHelper;

public class AlbumCardBoostManager
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger(AlbumCardBoostManager.class);
    private static final Gson GSON = new Gson();
    private AlbumCardBoostCollection collection = AlbumCardBoostCollection.empty();

    public AlbumCardBoostManager() {
        super(GSON, "card_boosts");
    }

    public Optional<AlbumCardBoostCollection> getBoosts() {
        return Optional.ofNullable(this.collection);
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        LOGGER.info("Loading album boosts");
        EnumMap<OpType, List> loaded = new EnumMap<OpType, List>(OpType.class);
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            ResourceLocation filePath = entry.getKey();
            JsonElement fileData = entry.getValue();
            try {
                JsonObject data = JsonHelper.asObject(fileData);
                String opTypeId = GsonHelper.m_13906_((JsonObject)data, (String)"op");
                OpType type = OpType.valueOf(opTypeId);
                List values = loaded.computeIfAbsent(type, k -> new ArrayList());
                Object action = ActionType.fromJson(type, GsonHelper.m_13930_((JsonObject)data, (String)"action"));
                values.add(action);
            }
            catch (JsonParseException | IllegalArgumentException e) {
                LOGGER.error("Error loading {} file: {}", (Object)filePath, (Object)e);
            }
        }
        this.collection = new AlbumCardBoostCollection(((List)loaded.get((Object)OpType.CLEANUP)).toArray(new IAction[0]), ((List)loaded.get((Object)OpType.ACTIVE)).toArray(new IAction[0]));
        LOGGER.info("Album boosts loaded");
    }
}

