/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.data.boosts;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import team.tnt.collectoralbum.common.init.CardBoostConditionRegistry;
import team.tnt.collectoralbum.data.boosts.ICardBoostCondition;
import team.tnt.collectoralbum.data.boosts.ICardBoostConditionSerializer;
import team.tnt.collectoralbum.util.JsonHelper;

public final class CardBoostConditionType<C extends ICardBoostCondition> {
    private final ResourceLocation id;
    private final ICardBoostConditionSerializer<C> serializer;

    public CardBoostConditionType(ResourceLocation id, ICardBoostConditionSerializer<C> serializer) {
        this.id = id;
        this.serializer = serializer;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public static <C extends ICardBoostCondition> C fromJson(JsonElement element) throws JsonParseException {
        JsonObject object = JsonHelper.asObject(element);
        ResourceLocation location = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"type"));
        CardBoostConditionType type = CardBoostConditionRegistry.lookup(location);
        if (type == null) {
            throw new JsonSyntaxException("Unknown condition type: " + location);
        }
        ICardBoostConditionSerializer<C> serializer = type.serializer;
        return serializer.fromJson((JsonElement)object);
    }

    public static <C extends ICardBoostCondition> void encode(C condition, FriendlyByteBuf buffer) {
        CardBoostConditionType<?> type = condition.getType();
        ICardBoostConditionSerializer<C> serializer = type.serializer;
        buffer.m_130085_(type.id);
        serializer.networkEncode(condition, buffer);
    }

    public static <C extends ICardBoostCondition> C decode(FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.m_130281_();
        CardBoostConditionType type = CardBoostConditionRegistry.lookup(id);
        ICardBoostConditionSerializer serializer = type.serializer;
        return serializer.networkDecode(type, buffer);
    }
}

