/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.data.boosts;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;
import team.tnt.collectoralbum.common.AlbumStats;
import team.tnt.collectoralbum.common.ICardCategory;
import team.tnt.collectoralbum.common.init.CardBoostConditionRegistry;
import team.tnt.collectoralbum.common.init.CardCategoryRegistry;
import team.tnt.collectoralbum.common.item.CardRarity;
import team.tnt.collectoralbum.common.item.ICard;
import team.tnt.collectoralbum.data.boosts.CardBoostConditionType;
import team.tnt.collectoralbum.data.boosts.IBoostContext;
import team.tnt.collectoralbum.data.boosts.ICardBoostCondition;
import team.tnt.collectoralbum.data.boosts.ICardBoostConditionSerializer;
import team.tnt.collectoralbum.data.boosts.IDescriptionProvider;
import team.tnt.collectoralbum.data.boosts.PointsCondition;
import team.tnt.collectoralbum.util.JsonHelper;
import team.tnt.collectoralbum.util.TextHelper;

public class CardsCondition
implements ICardBoostCondition {
    private final ICardCategory category;
    private final CardRarity rarity;
    private final int count;
    private final Component[] description;

    private CardsCondition(ICardCategory category, CardRarity rarity, int count) {
        this.category = category;
        this.rarity = rarity;
        this.count = count;
        this.description = new Component[]{this.createFullDescription()};
    }

    @Override
    public CardBoostConditionType<?> getType() {
        return CardBoostConditionRegistry.CARDS;
    }

    @Override
    public boolean isValid(IBoostContext context) {
        AlbumStats stats = context.get("stats", AlbumStats.class);
        Map<ICardCategory, List<ICard>> map = stats.getCardsByCategory();
        List<Object> cardList = this.category == null ? CardCategoryRegistry.getValues().stream().flatMap(cat -> Optional.ofNullable((List)map.get(cat)).stream()).flatMap(Collection::stream).toList() : Optional.ofNullable(map.get(this.category)).orElse(Collections.emptyList());
        if (this.rarity != null) {
            cardList = cardList.stream().filter(card -> card.getCardRarity() == this.rarity).toList();
        }
        return cardList.size() >= this.count;
    }

    @Override
    public Component[] getDescription() {
        return this.description;
    }

    private Component createFullDescription() {
        MutableComponent wildcard = Component.m_237115_((String)"text.collectorsalbum.album.boost.condition.cards.wildcard");
        MutableComponent count = Component.m_237113_((String)String.valueOf(this.count)).m_130940_(ChatFormatting.AQUA);
        MutableComponent categoryText = this.category != null ? Component.m_237113_((String)this.category.getTranslatedName().getString()).m_130940_(this.category.getTooltipFormat()) : wildcard;
        MutableComponent rarityText = this.rarity != null ? this.rarity.getTranslatedName() : wildcard;
        return Component.m_237110_((String)"text.collectorsalbum.album.boost.condition.cards", (Object[])new Object[]{count, rarityText, categoryText}).m_130940_(ChatFormatting.GRAY);
    }

    @Override
    public int compareTo(@NotNull IDescriptionProvider o) {
        if (o instanceof PointsCondition) {
            return 1;
        }
        if (o instanceof CardsCondition) {
            CardsCondition c = (CardsCondition)o;
            CardRarity oRarity = c.rarity;
            int oCount = c.count;
            if (oCount == this.count) {
                if (Objects.equals((Object)this.rarity, (Object)oRarity)) {
                    if (this.category == null && Objects.equals(this.category, c.category)) {
                        return 0;
                    }
                    return this.category.getIndex() - c.category.getIndex();
                }
                return this.rarity == null || oRarity == null ? TextHelper.nullSortFirst(this.rarity, oRarity) : this.rarity.ordinal() - oRarity.ordinal();
            }
            return this.count - oCount;
        }
        return 0;
    }

    public static final class Serializer
    implements ICardBoostConditionSerializer<CardsCondition> {
        @Override
        public CardsCondition fromJson(JsonElement element) throws JsonParseException {
            JsonObject object = JsonHelper.asObject(element);
            String categoryId = JsonHelper.resolveNullable(object, "category", JsonElement::getAsString);
            String rarityId = JsonHelper.resolveNullable(object, "rarity", JsonElement::getAsString);
            CardRarity rarity = null;
            if (rarityId != null) {
                try {
                    rarity = CardRarity.valueOf(rarityId);
                }
                catch (IllegalArgumentException e) {
                    throw new JsonSyntaxException("Unknown card rarity: " + rarityId);
                }
            }
            ICardCategory category = null;
            if (categoryId != null && (category = CardCategoryRegistry.getByKey(new ResourceLocation(categoryId))) == null) {
                throw new JsonSyntaxException("Unknown card category: " + categoryId);
            }
            int requiredCount = GsonHelper.m_13927_((JsonObject)object, (String)"count");
            return new CardsCondition(category, rarity, requiredCount);
        }

        @Override
        public void networkEncode(CardsCondition condition, FriendlyByteBuf buffer) {
            ICardCategory cardCategory = condition.category;
            CardRarity rarity = condition.rarity;
            buffer.writeBoolean(cardCategory != null);
            if (cardCategory != null) {
                buffer.m_130085_(cardCategory.getId());
            }
            buffer.writeBoolean(rarity != null);
            if (rarity != null) {
                buffer.m_130068_((Enum)rarity);
            }
            buffer.writeInt(condition.count);
        }

        @Override
        public CardsCondition networkDecode(CardBoostConditionType<CardsCondition> type, FriendlyByteBuf buffer) {
            boolean hasCategory = buffer.readBoolean();
            ICardCategory cardCategory = hasCategory ? CardCategoryRegistry.getByKey(buffer.m_130281_()) : null;
            boolean hasRarity = buffer.readBoolean();
            CardRarity rarity = hasRarity ? (CardRarity)buffer.m_130066_(CardRarity.class) : null;
            int count = buffer.readInt();
            return new CardsCondition(cardCategory, rarity, count);
        }
    }
}

