/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.data.boosts;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;
import team.tnt.collectoralbum.common.init.ActionTypeRegistry;
import team.tnt.collectoralbum.data.boosts.ActionType;
import team.tnt.collectoralbum.data.boosts.IAction;
import team.tnt.collectoralbum.data.boosts.IActionSerializer;
import team.tnt.collectoralbum.data.boosts.IBoostContext;
import team.tnt.collectoralbum.data.boosts.OpType;
import team.tnt.collectoralbum.util.JsonHelper;

public class ClearEffectsAction
implements IAction {
    private final MobEffect[] effects;

    public ClearEffectsAction(MobEffect[] effects) {
        this.effects = effects;
    }

    @Override
    public ActionType<?> getType() {
        return ActionTypeRegistry.CLEAR_EFFECTS;
    }

    @Override
    public void apply(IBoostContext context) {
        Player player = context.get("player", Player.class);
        for (MobEffect effect : this.effects) {
            player.m_21195_(effect);
        }
    }

    @Override
    public Component[] getDescription() {
        return new Component[0];
    }

    public static final class Serializer
    implements IActionSerializer<ClearEffectsAction> {
        @Override
        public ClearEffectsAction fromJson(JsonObject data, OpType opType) throws JsonParseException {
            JsonArray array = GsonHelper.m_13933_((JsonObject)data, (String)"effects");
            MobEffect[] effects = (MobEffect[])JsonHelper.resolveRegistryObjectsFromIdArray(array, Registry.f_122823_, MobEffect[]::new);
            return new ClearEffectsAction(effects);
        }

        @Override
        public void networkEncode(ClearEffectsAction action, FriendlyByteBuf buffer) {
            buffer.writeInt(action.effects.length);
            for (MobEffect effect : action.effects) {
                buffer.m_130085_(ForgeRegistries.MOB_EFFECTS.getKey((Object)effect));
            }
        }

        @Override
        public ClearEffectsAction networkDecode(ActionType<ClearEffectsAction> type, FriendlyByteBuf buffer) {
            int count = buffer.readInt();
            MobEffect[] effects = new MobEffect[count];
            for (int i = 0; i < count; ++i) {
                effects[i] = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(buffer.m_130281_());
            }
            return new ClearEffectsAction(effects);
        }
    }
}

