/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.data.boosts;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Arrays;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;
import team.tnt.collectoralbum.common.init.ActionTypeRegistry;
import team.tnt.collectoralbum.data.boosts.ActionType;
import team.tnt.collectoralbum.data.boosts.CardBoostConditionType;
import team.tnt.collectoralbum.data.boosts.IAction;
import team.tnt.collectoralbum.data.boosts.IActionSerializer;
import team.tnt.collectoralbum.data.boosts.IBoostContext;
import team.tnt.collectoralbum.data.boosts.ICardBoostCondition;
import team.tnt.collectoralbum.data.boosts.IDescriptionProvider;
import team.tnt.collectoralbum.data.boosts.OpType;
import team.tnt.collectoralbum.util.JsonHelper;

public class FirstValidAction
implements IAction {
    private final Entry[] entries;
    private final Component[] description;

    private FirstValidAction(Entry[] entries) {
        this.entries = entries;
        this.description = this.generateDescription(entries);
    }

    @Override
    public ActionType<?> getType() {
        return ActionTypeRegistry.FIRST_VALID;
    }

    @Override
    public void apply(IBoostContext context) {
        for (Entry entry : this.entries) {
            if (!entry.accepts(context)) continue;
            entry.apply(context);
            break;
        }
    }

    @Override
    public Component[] getDescription() {
        return this.description;
    }

    @Override
    public int compareTo(@NotNull IDescriptionProvider o) {
        if (o instanceof FirstValidAction) {
            FirstValidAction fva = (FirstValidAction)o;
            Entry[] vals = fva.entries;
            if (this.entries.length > 0 && vals.length > 0) {
                return this.compareEntries(this.entries[0], vals[0]);
            }
            return this.entries.length - vals.length;
        }
        return 0;
    }

    private Component[] generateDescription(Entry[] entries) {
        return (Component[])Arrays.stream(entries).sorted(this::compareEntries).flatMap(e -> Arrays.stream(e.getDescription())).toArray(Component[]::new);
    }

    private int compareEntries(Entry o1, Entry o2) {
        ICardBoostCondition[] c1 = o1.conditions;
        ICardBoostCondition[] c2 = o2.conditions;
        if (c1.length > 0 && c2.length > 0) {
            return c1[0].compareTo(c2[0]);
        }
        return o1.action.compareTo(o2.action);
    }

    public static final class Entry
    implements IDescriptionProvider {
        private final ICardBoostCondition[] conditions;
        private final IAction action;

        public Entry(ICardBoostCondition[] conditions, IAction action) {
            this.conditions = conditions;
            this.action = action;
        }

        public boolean accepts(IBoostContext ctx) {
            for (ICardBoostCondition condition : this.conditions) {
                if (condition.isValid(ctx)) continue;
                return false;
            }
            return true;
        }

        public void apply(IBoostContext ctx) {
            this.action.apply(ctx);
        }

        @Override
        public Component[] getDescription() {
            Component[] conditionsDesc = (Component[])Arrays.stream(this.conditions).flatMap(cond -> Arrays.stream(cond.getDescription())).toArray(Component[]::new);
            Component[] actionDesc = this.action.getDescription();
            Component[] res = new Component[conditionsDesc.length + actionDesc.length];
            System.arraycopy(conditionsDesc, 0, res, 0, conditionsDesc.length);
            System.arraycopy(actionDesc, 0, res, conditionsDesc.length, actionDesc.length);
            return res;
        }

        static Entry fromJson(JsonElement element, OpType opType) throws JsonParseException {
            JsonObject object = JsonHelper.asObject(element);
            JsonObject applyAction = GsonHelper.m_13930_((JsonObject)object, (String)"apply");
            JsonArray conditionsArray = GsonHelper.m_13832_((JsonObject)object, (String)"conditions", (JsonArray)new JsonArray());
            Object action = ActionType.fromJson(opType, applyAction);
            ICardBoostCondition[] conditions = JsonHelper.resolveArray(conditionsArray, ICardBoostCondition[]::new, CardBoostConditionType::fromJson);
            return new Entry(conditions, (IAction)action);
        }

        void encode(FriendlyByteBuf buffer) {
            ActionType.encode(this.action, buffer);
            buffer.writeInt(this.conditions.length);
            for (ICardBoostCondition condition : this.conditions) {
                CardBoostConditionType.encode(condition, buffer);
            }
        }

        static Entry decode(FriendlyByteBuf buffer) {
            Object action = ActionType.decode(buffer);
            int count = buffer.readInt();
            ICardBoostCondition[] cardBoostConditions = new ICardBoostCondition[count];
            for (int i = 0; i < count; ++i) {
                cardBoostConditions[i] = CardBoostConditionType.decode(buffer);
            }
            return new Entry(cardBoostConditions, (IAction)action);
        }
    }

    public static final class Serializer
    implements IActionSerializer<FirstValidAction> {
        @Override
        public FirstValidAction fromJson(JsonObject data, OpType opType) throws JsonParseException {
            JsonArray valuesArr = GsonHelper.m_13933_((JsonObject)data, (String)"values");
            Entry[] entries = JsonHelper.resolveArray(valuesArr, Entry[]::new, element -> Entry.fromJson(element, opType));
            return new FirstValidAction(entries);
        }

        @Override
        public void networkEncode(FirstValidAction action, FriendlyByteBuf buffer) {
            buffer.writeInt(action.entries.length);
            for (Entry entry : action.entries) {
                entry.encode(buffer);
            }
        }

        @Override
        public FirstValidAction networkDecode(ActionType<FirstValidAction> type, FriendlyByteBuf buffer) {
            int i = buffer.readInt();
            Entry[] entries = new Entry[i];
            for (int j = 0; j < i; ++j) {
                entries[j] = Entry.decode(buffer);
            }
            return new FirstValidAction(entries);
        }
    }
}

