/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.data.boosts;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import team.tnt.collectoralbum.common.init.ActionTypeRegistry;
import team.tnt.collectoralbum.data.boosts.ActionType;
import team.tnt.collectoralbum.data.boosts.GiveEffectsAction;
import team.tnt.collectoralbum.data.boosts.IAction;
import team.tnt.collectoralbum.data.boosts.IActionSerializer;
import team.tnt.collectoralbum.data.boosts.IBoostContext;
import team.tnt.collectoralbum.data.boosts.OpType;
import team.tnt.collectoralbum.util.JsonHelper;

public class GiveMissingEffectAction
implements IAction {
    private final GiveEffectsAction.IEffectFactory[] factories;
    private final Component[] description;

    public GiveMissingEffectAction(GiveEffectsAction.IEffectFactory[] factories) {
        this.factories = factories;
        this.description = GiveEffectsAction.generateDescriptionForEffects(factories);
    }

    @Override
    public ActionType<?> getType() {
        return ActionTypeRegistry.GIVE_MISSING_EFFECTS;
    }

    @Override
    public void apply(IBoostContext context) {
        Player player = context.get("player", Player.class);
        for (GiveEffectsAction.IEffectFactory factory : this.factories) {
            MobEffectInstance instance = factory.makeEffect();
            MobEffectInstance old = player.m_21124_(instance.m_19544_());
            if (old != null && old.m_19564_() == instance.m_19564_()) continue;
            player.m_21195_(instance.m_19544_());
            player.m_7292_(instance);
        }
    }

    @Override
    public Component[] getDescription() {
        return this.description;
    }

    public static final class Serializer
    implements IActionSerializer<GiveMissingEffectAction> {
        @Override
        public GiveMissingEffectAction fromJson(JsonObject data, OpType opType) throws JsonParseException {
            JsonArray array = GsonHelper.m_13933_((JsonObject)data, (String)"effects");
            GiveEffectsAction.IEffectFactory[] factories = new GiveEffectsAction.IEffectFactory[array.size()];
            int i = 0;
            for (JsonElement element : array) {
                JsonObject effectJson = JsonHelper.asObject(element);
                ResourceLocation effectId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)effectJson, (String)"effect"));
                MobEffect effect = (MobEffect)Registry.f_122823_.m_7745_(effectId);
                if (effect == null) {
                    throw new JsonSyntaxException("Unknown effect: " + effectId);
                }
                int duration = Math.max(GsonHelper.m_13824_((JsonObject)effectJson, (String)"duration", (int)20), 0);
                int amplifier = Mth.m_14045_((int)GsonHelper.m_13824_((JsonObject)effectJson, (String)"amplifier", (int)0), (int)0, (int)255);
                boolean ambient = GsonHelper.m_13855_((JsonObject)effectJson, (String)"ambient", (boolean)false);
                boolean visible = GsonHelper.m_13855_((JsonObject)effectJson, (String)"visible", (boolean)true);
                boolean showIcon = GsonHelper.m_13855_((JsonObject)effectJson, (String)"showIcon", (boolean)true);
                factories[i++] = () -> new MobEffectInstance(effect, duration, amplifier, ambient, visible, showIcon);
            }
            return new GiveMissingEffectAction(factories);
        }

        @Override
        public void networkEncode(GiveMissingEffectAction action, FriendlyByteBuf buffer) {
            buffer.writeInt(action.factories.length);
            for (GiveEffectsAction.IEffectFactory factory : action.factories) {
                GiveEffectsAction.encodeEffectFactory(factory, buffer);
            }
        }

        @Override
        public GiveMissingEffectAction networkDecode(ActionType<GiveMissingEffectAction> type, FriendlyByteBuf buffer) {
            GiveEffectsAction.IEffectFactory[] factories = new GiveEffectsAction.IEffectFactory[buffer.readInt()];
            for (int i = 0; i < factories.length; ++i) {
                factories[i] = GiveEffectsAction.decodeEffectFactory(buffer);
            }
            return new GiveMissingEffectAction(factories);
        }
    }
}

