/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.data.packs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.tnt.collectoralbum.data.packs.CardDropProviderType;
import team.tnt.collectoralbum.data.packs.ICardDropProvider;

public class CardPackLootManager
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger(CardPackLootManager.class);
    private static final Gson GSON = new GsonBuilder().create();
    private final Map<ResourceLocation, ICardDropProvider> providerMap = new HashMap<ResourceLocation, ICardDropProvider>();

    public CardPackLootManager() {
        super(GSON, "card_packs");
    }

    public Optional<ICardDropProvider> getProvider(ResourceLocation identifier) {
        return Optional.ofNullable(this.providerMap.get(identifier));
    }

    protected void apply(Map<ResourceLocation, JsonElement> resources, ResourceManager resourceManager, ProfilerFiller profiler) {
        LOGGER.info("Loading card pack drops");
        this.providerMap.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : resources.entrySet()) {
            try {
                ResourceLocation path = entry.getKey();
                JsonElement data = entry.getValue();
                Object provider = CardDropProviderType.fromJson(data);
                this.providerMap.put(path, (ICardDropProvider)provider);
            }
            catch (JsonParseException e) {
                LOGGER.error("Error loading card pack provider with id {}, error {}", (Object)entry.getKey(), (Object)e);
            }
        }
        LOGGER.info("Loaded {} card pack drops", (Object)this.providerMap.size());
    }
}

