/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.network.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import team.tnt.collectoralbum.client.screen.CardOpenScreen;
import team.tnt.collectoralbum.network.packet.AbstractNetworkPacket;

public class OpenCardScreenPacket
extends AbstractNetworkPacket<OpenCardScreenPacket> {
    private final List<ItemStack> drops;

    public OpenCardScreenPacket() {
        this.drops = Collections.emptyList();
    }

    public OpenCardScreenPacket(List<ItemStack> drops) {
        this.drops = drops;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.drops.size());
        for (ItemStack stack : this.drops) {
            buffer.m_130055_(stack);
        }
    }

    @Override
    public OpenCardScreenPacket decode(FriendlyByteBuf buffer) {
        int count = buffer.readInt();
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(count);
        for (int i = 0; i < count; ++i) {
            ItemStack stack = buffer.m_130267_();
            list.add(stack);
        }
        return new OpenCardScreenPacket(list);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(NetworkEvent.Context context) {
        CardOpenScreen screen = new CardOpenScreen(this.drops);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }
}

