/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Map;
import net.brdle.collectorsreap.common.block.EffectCakeBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.tag.ForgeTags;

public class EffectCandleCakeBlock
extends AbstractCandleBlock {
    protected static final VoxelShape CAKE_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    protected static final VoxelShape CANDLE_SHAPE = Block.m_49796_((double)7.0, (double)8.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0);
    protected static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)CAKE_SHAPE, (VoxelShape)CANDLE_SHAPE);
    private static final Iterable<Vec3> PARTICLE_OFFSETS = ImmutableList.of((Object)new Vec3(0.5, 1.0, 0.5));
    private static final Map<Pair<Block, Block>, Block> BY_CAKE_CANDLE = Maps.newHashMap();
    private final EffectCakeBlock cake;

    public EffectCandleCakeBlock(Block cake, Block candle, BlockBehaviour.Properties prop) {
        super(prop);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_151895_, (Comparable)Boolean.FALSE));
        BY_CAKE_CANDLE.put((Pair<Block, Block>)Pair.of((Object)cake, (Object)candle), (Block)this);
        this.cake = (EffectCakeBlock)cake;
    }

    public EffectCakeBlock getCake() {
        return this.cake;
    }

    @NotNull
    protected Iterable<Vec3> m_142199_(@NotNull BlockState pState) {
        return PARTICLE_OFFSETS;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPE;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult result) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!itemstack.m_150930_(Items.f_42409_) && !itemstack.m_150930_(Items.f_42613_)) {
            if (EffectCandleCakeBlock.candleHit(result) && player.m_21120_(hand).m_41619_() && ((Boolean)state.m_61143_((Property)f_151895_)).booleanValue()) {
                EffectCandleCakeBlock.m_151899_((Player)player, (BlockState)state, (LevelAccessor)level, (BlockPos)pos);
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            if (itemstack.m_204117_(ForgeTags.TOOLS_KNIVES)) {
                return this.cutSlice(level, pos, state, player);
            }
            return this.eatSlice(level, pos, state, player);
        }
        return InteractionResult.PASS;
    }

    public InteractionResult eatSlice(Level level, BlockPos pos, BlockState state, Player player) {
        if (!player.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        player.m_36220_(Stats.f_12942_);
        Item slice = this.getCake().getSlice();
        ItemStack sliceStack = slice.m_7968_();
        player.m_36324_().eat(slice, sliceStack, (LivingEntity)player);
        EffectCakeBlock.addEatEffect(sliceStack, level, player);
        level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
        level.m_7731_(pos, (BlockState)this.getCake().m_49966_().m_61124_((Property)EffectCakeBlock.f_51180_, (Comparable)Integer.valueOf(1)), 3);
        Block.m_49950_((BlockState)state, (Level)level, (BlockPos)pos);
        return InteractionResult.SUCCESS;
    }

    public InteractionResult cutSlice(Level level, BlockPos pos, BlockState state, Player player) {
        level.m_7731_(pos, (BlockState)this.getCake().m_49966_().m_61124_((Property)EffectCakeBlock.f_51180_, (Comparable)Integer.valueOf(1)), 3);
        Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)this.getCake().getSlice().m_7968_());
        Block.m_49950_((BlockState)state, (Level)level, (BlockPos)pos);
        level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    private static boolean candleHit(BlockHitResult pHit) {
        return pHit.m_82450_().f_82480_ - (double)pHit.m_82425_().m_123342_() > 0.5;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_151895_});
    }

    @NotNull
    public ItemStack m_7397_(@NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState) {
        return this.getCake().getSlice().m_7968_();
    }

    public static BlockState byCakeCandle(CakeBlock cake, CandleBlock candle) {
        return BY_CAKE_CANDLE.get(Pair.of((Object)cake, (Object)candle)).m_49966_();
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState pState, @NotNull Direction pDirection, @NotNull BlockState pNeighborState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pNeighborPos) {
        return pDirection == Direction.DOWN && !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    public boolean m_7898_(@NotNull BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return pLevel.m_8055_(pPos.m_7495_()).m_60767_().m_76333_();
    }

    @Deprecated
    public int m_6782_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos) {
        return CakeBlock.f_152743_;
    }

    @Deprecated
    public boolean m_7278_(@NotNull BlockState pState) {
        return true;
    }

    public boolean m_7357_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull PathComputationType pType) {
        return false;
    }

    public static boolean canLight(BlockState pState) {
        return pState.m_204338_(BlockTags.f_144268_, p_152896_ -> p_152896_.m_61138_((Property)f_151895_) && (Boolean)pState.m_61143_((Property)f_151895_) == false);
    }
}

