/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.common.block;

import com.google.common.collect.ImmutableList;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ScentedCandleBlock
extends AbstractCandleBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty LIT = AbstractCandleBlock.f_151895_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final ToIntFunction<BlockState> LIGHT_EMISSION = c -> (Boolean)c.m_61143_((Property)LIT) != false ? 3 : 0;
    private static final VoxelShape SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)6.0, (double)9.0);

    public ScentedCandleBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        if (pPlayer.m_150110_().f_35938_ && pPlayer.m_21120_(pHand).m_41619_() && ((Boolean)pState.m_61143_((Property)LIT)).booleanValue()) {
            ScentedCandleBlock.m_151899_((Player)pPlayer, (BlockState)pState, (LevelAccessor)pLevel, (BlockPos)pPos);
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState blockstate = pContext.m_43725_().m_8055_(pContext.m_8083_());
        if (blockstate.m_60713_((Block)this)) {
            return blockstate;
        }
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        return (BlockState)super.m_5573_(pContext).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    @NotNull
    public BlockState m_7417_(BlockState pState, @NotNull Direction pDirection, @NotNull BlockState pNeighborState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pNeighborPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    @NotNull
    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{LIT, WATERLOGGED});
    }

    public boolean m_7361_(@NotNull LevelAccessor pLevel, @NotNull BlockPos pPos, BlockState pState, @NotNull FluidState pFluidState) {
        if (!((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue() && pFluidState.m_76152_() == Fluids.f_76193_) {
            BlockState blockstate = (BlockState)pState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
            if (((Boolean)pState.m_61143_((Property)LIT)).booleanValue()) {
                ScentedCandleBlock.m_151899_(null, (BlockState)blockstate, (LevelAccessor)pLevel, (BlockPos)pPos);
            } else {
                pLevel.m_7731_(pPos, blockstate, 3);
            }
            pLevel.m_186469_(pPos, pFluidState.m_76152_(), pFluidState.m_76152_().m_6718_((LevelReader)pLevel));
            return true;
        }
        return false;
    }

    public static boolean canLight(BlockState pState) {
        return pState.m_204338_(BlockTags.f_144265_, c -> c.m_61138_((Property)LIT) && c.m_61138_((Property)WATERLOGGED)) && (Boolean)pState.m_61143_((Property)LIT) == false && (Boolean)pState.m_61143_((Property)WATERLOGGED) == false;
    }

    @NotNull
    protected Iterable<Vec3> m_142199_(@NotNull BlockState pState) {
        return ImmutableList.of((Object)new Vec3(0.5, 0.5, 0.5));
    }

    protected boolean m_142595_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) == false && super.m_142595_(pState);
    }

    public boolean m_7898_(@NotNull BlockState pState, @NotNull LevelReader pLevel, BlockPos pPos) {
        return Block.m_49863_((LevelReader)pLevel, (BlockPos)pPos.m_7495_(), (Direction)Direction.UP);
    }
}

