/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.common.item.food;

import com.google.common.collect.Lists;
import java.util.List;
import net.brdle.collectorsreap.common.item.CRItems;
import net.brdle.collectorsreap.compat.ModCompat;
import net.brdle.collectorsreap.compat.NeapolitanCompat;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.item.ConsumableItem;

public class ShakeItem
extends ConsumableItem {
    private static final int MAX_NEARBY = 3;

    public ShakeItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull LivingEntity entity) {
        this.handleEffects(entity);
        return super.m_5922_(stack, worldIn, entity);
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity entity, @NotNull InteractionHand hand) {
        if (!ModList.get().isLoaded("neapolitan")) {
            return InteractionResult.FAIL;
        }
        if (entity.f_19853_.m_5776_()) {
            return InteractionResult.CONSUME;
        }
        entity.f_19853_.m_5594_(null, entity.m_20183_(), SoundEvents.f_12585_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverplayerentity = (ServerPlayer)player;
            CriteriaTriggers.f_10592_.m_23682_(serverplayerentity, stack);
            serverplayerentity.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
        if (entity.m_21124_(NeapolitanCompat.VANILLA_SCENT.get()) == null) {
            this.handleEffects(entity);
        }
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
            ItemStack itemstack = new ItemStack((ItemLike)Items.f_42590_);
            if (!player.m_150109_().m_36054_(itemstack)) {
                player.m_36176_(itemstack, false);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void handleEffects(LivingEntity user) {
        List<Object> effects = Lists.newArrayList((Iterable)user.m_21220_());
        List nearest = user.f_19853_.m_45971_(LivingEntity.class, TargetingConditions.f_26872_.m_26888_(living -> living != user && living.m_21124_(ModCompat.getVanillaScent().get()) == null), user, user.m_20191_().m_82377_(6.0, 2.0, 6.0)).stream().limit(3L).toList();
        if (nearest.size() > 0) {
            for (LivingEntity near : nearest) {
                if (this == CRItems.LIME_MILKSHAKE.get()) {
                    effects = effects.stream().filter(i -> !i.m_19544_().m_19486_()).map(i -> new MobEffectInstance(i.m_19544_(), i.m_19557_() / 2, i.m_19564_())).toList();
                } else if (this == CRItems.POMEGRANATE_MILKSHAKE.get()) {
                    effects = effects.stream().filter(i -> i.m_19544_().m_19486_()).map(i -> new MobEffectInstance(i.m_19544_(), i.m_19557_() / 2, i.m_19564_())).toList();
                }
                effects.forEach(arg_0 -> ((LivingEntity)near).m_7292_(arg_0));
            }
        }
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 40;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.DRINK;
    }

    @NotNull
    public SoundEvent m_6023_() {
        return SoundEvents.f_11970_;
    }

    @NotNull
    public SoundEvent m_6061_() {
        return SoundEvents.f_11970_;
    }
}

