/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.value;

import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.exception.ConfigValueMissingException;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.ValueData;
import net.minecraft.network.FriendlyByteBuf;

public class EnumValue<E extends Enum<E>>
extends ConfigValue<E> {
    public EnumValue(ValueData<E> valueData) {
        super(valueData);
    }

    @Override
    protected void serialize(IConfigFormat format) {
        format.writeEnum(this.getId(), (Enum)this.get());
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.set(format.readEnum(this.getId(), this.getValueType()));
    }

    public static final class Adapter<E extends Enum<E>>
    extends TypeAdapter {
        @Override
        public ConfigValue<?> serialize(String name, String[] comments, Object value, TypeAdapter.TypeSerializer serializer, TypeAdapter.AdapterContext context) throws IllegalAccessException {
            return new EnumValue<Enum>(ValueData.of(name, (Enum)value, context, comments));
        }

        @Override
        public void encodeToBuffer(ConfigValue<?> value, FriendlyByteBuf buffer) {
            buffer.m_130068_((Enum)value.get());
        }

        @Override
        public Object decodeFromBuffer(ConfigValue<?> value, FriendlyByteBuf buffer) {
            Class<?> type = value.getValueType();
            return buffer.m_130066_(type);
        }
    }
}

