/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.ComparatorUtil;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.BlazeEnchanterBlockEntity;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.Enchanting;
import plus.dragons.createenchantmentindustry.entry.CeiBlockEntities;
import plus.dragons.createenchantmentindustry.entry.CeiItems;

public class BlazeEnchanterBlock
extends HorizontalDirectionalBlock
implements IWrenchable,
IBE<BlazeEnchanterBlockEntity> {
    public static final EnumProperty<HeatLevel> HEAT_LEVEL = EnumProperty.m_61587_((String)"blaze", HeatLevel.class);

    public BlazeEnchanterBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(HEAT_LEVEL, (Comparable)((Object)HeatLevel.SMOULDERING)));
    }

    public Class<BlazeEnchanterBlockEntity> getBlockEntityClass() {
        return BlazeEnchanterBlockEntity.class;
    }

    public BlockEntityType<? extends BlazeEnchanterBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CeiBlockEntities.BLAZE_ENCHANTER.get();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HEAT_LEVEL, f_54117_});
    }

    public Item m_5456_() {
        return ((BlazeBurnerBlock)AllBlocks.BLAZE_BURNER.get()).m_5456_();
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos blockPos, CollisionContext pContext) {
        return AllShapes.HEATER_BLOCK_SHAPE;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack heldItem = player.m_7500_() ? player.m_21120_(handIn).m_41777_() : player.m_21120_(handIn);
        if (player.m_6144_() && handIn == InteractionHand.MAIN_HAND && heldItem.m_41619_()) {
            BlockEntity blockEntity;
            if (!player.f_19853_.m_5776_() && (blockEntity = player.f_19853_.m_7702_(pos)) instanceof BlazeEnchanterBlockEntity) {
                BlazeEnchanterBlockEntity blazeEnchanter = (BlazeEnchanterBlockEntity)blockEntity;
                this.withBlockEntityDo((BlockGetter)player.f_19853_, pos, toolbox -> NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)blazeEnchanter, buf -> {
                    buf.m_130055_(blazeEnchanter.targetItem);
                    buf.writeBoolean(false);
                    buf.m_130064_(pos);
                }));
            }
            return InteractionResult.SUCCESS;
        }
        if (!heldItem.m_41619_()) {
            return this.onBlockEntityUse((BlockGetter)worldIn, pos, te -> {
                if (heldItem.m_150930_((Item)CeiItems.ENCHANTING_GUIDE.get())) {
                    if (!worldIn.f_46443_) {
                        ItemStack target = te.targetItem.m_41777_();
                        te.targetItem = heldItem;
                        if (!player.m_150110_().f_35937_) {
                            player.m_21008_(handIn, target);
                        }
                        te.notifyUpdate();
                    }
                    return InteractionResult.SUCCESS;
                }
                if (Enchanting.getValidEnchantment(heldItem, te.targetItem, te.hyper()) != null) {
                    ItemStack heldItemStack = te.getHeldItemStack();
                    if (heldItemStack.m_41619_()) {
                        if (!worldIn.f_46443_) {
                            te.heldItem = new TransportedItemStack(heldItem);
                            if (!player.m_150110_().f_35937_) {
                                player.m_21008_(handIn, ItemStack.f_41583_);
                            }
                            te.notifyUpdate();
                        }
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.FAIL;
                }
                if (AllItems.GOGGLES.isIn(heldItem)) {
                    if (te.goggles) {
                        return InteractionResult.PASS;
                    }
                    te.goggles = true;
                    te.notifyUpdate();
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            });
        }
        return this.onBlockEntityUse((BlockGetter)worldIn, pos, te -> {
            ItemStack heldItemStack = te.getHeldItemStack();
            if (!heldItemStack.m_41619_()) {
                if (!worldIn.f_46443_) {
                    te.heldItem = null;
                    player.m_21008_(handIn, heldItemStack);
                    te.notifyUpdate();
                }
                return InteractionResult.SUCCESS;
            }
            if (!te.goggles) {
                return InteractionResult.PASS;
            }
            te.goggles = false;
            te.notifyUpdate();
            return InteractionResult.SUCCESS;
        });
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (world instanceof ServerLevel && player != null) {
            player.f_19853_.m_46597_(pos, (BlockState)((BlockState)AllBlocks.BLAZE_BURNER.getDefaultState().m_61124_((Property)BlazeBurnerBlock.f_54117_, (Comparable)((Direction)state.m_61143_((Property)f_54117_)))).m_61124_((Property)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.SMOULDERING));
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy((Level)pLevel, (BlockPos)pPos, (LivingEntity)pPlacer);
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return new ItemStack((ItemLike)AllBlocks.BLAZE_BURNER.get());
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public List<ItemStack> m_7381_(BlockState pState, LootContext.Builder pBuilder) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((ItemLike)AllBlocks.BLAZE_BURNER.get()));
        return ret;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return ComparatorUtil.levelOfSmartFluidTank((BlockGetter)worldIn, (BlockPos)pos);
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    public static int getLight(BlockState state) {
        HeatLevel level = (HeatLevel)((Object)state.m_61143_(HEAT_LEVEL));
        return switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case HeatLevel.SEETHING -> 15;
            case HeatLevel.KINDLED -> 11;
            case HeatLevel.SMOULDERING -> 7;
        };
    }

    public static enum HeatLevel implements StringRepresentable
    {
        SMOULDERING,
        KINDLED,
        SEETHING;


        public static HeatLevel byIndex(int index) {
            return HeatLevel.values()[index];
        }

        public HeatLevel nextActiveLevel() {
            return HeatLevel.byIndex(this.ordinal() % (HeatLevel.values().length - 1) + 1);
        }

        public boolean isAtLeast(HeatLevel heatLevel) {
            return this.ordinal() >= heatLevel.ordinal();
        }

        public String m_7912_() {
            return Lang.asId((String)this.name());
        }
    }
}

