/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.dailyrewards.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonConfig {
    protected static final Logger log = LogManager.getLogger((String)"Daily Rewards");
    public static final ForgeConfigSpec commonSpec;
    public static final Config COMMON;

    protected CommonConfig() {
    }

    static {
        com.electronwill.nightconfig.core.Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Config)specPair.getLeft();
        log.info("{} Common config ...", (Object)"\ud83d\udcb0 Register Daily Rewards");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec);
    }

    public static class Config {
        public final ForgeConfigSpec.IntValue rewardTimePerDay;
        public final ForgeConfigSpec.BooleanValue showRewardMenuOnPlayerJoin;
        public final ForgeConfigSpec.BooleanValue useFillItems;
        public final ForgeConfigSpec.ConfigValue<List<String>> normalFillItems;
        public final ForgeConfigSpec.ConfigValue<List<String>> rareFillItems;
        public final ForgeConfigSpec.IntValue rareFillItemsChance;
        public final ForgeConfigSpec.ConfigValue<List<String>> lootBagFillItems;
        public final ForgeConfigSpec.IntValue lootBagFillItemsChance;
        public final ForgeConfigSpec.BooleanValue shuffleRewardsItems;
        public final ForgeConfigSpec.ConfigValue<List<String>> rewardsJanuaryItems;
        public final ForgeConfigSpec.ConfigValue<List<String>> rewardsFebruaryItems;
        public final ForgeConfigSpec.ConfigValue<List<String>> rewardsMarchItems;
        public final ForgeConfigSpec.ConfigValue<List<String>> rewardsAprilItems;
        public final ForgeConfigSpec.ConfigValue<List<String>> rewardsMayItems;
        public final ForgeConfigSpec.ConfigValue<List<String>> rewardsJuneItems;
        public final ForgeConfigSpec.ConfigValue<List<String>> rewardsJulyItems;
        public final ForgeConfigSpec.ConfigValue<List<String>> rewardsAugustItems;
        public final ForgeConfigSpec.ConfigValue<List<String>> rewardsSeptemberItems;
        public final ForgeConfigSpec.ConfigValue<List<String>> rewardsOctoberItems;
        public final ForgeConfigSpec.ConfigValue<List<String>> rewardsNovemberItems;
        public final ForgeConfigSpec.ConfigValue<List<String>> rewardsDecemberItems;

        Config(ForgeConfigSpec.Builder builder) {
            builder.comment("Daily Rewards (General configuration)");
            builder.push("General");
            this.rewardTimePerDay = builder.comment("Time in minutes the players needs to be online on the server before receiving a reward for the day.").defineInRange("rewardTimePerDay", 30, 1, 1440);
            this.showRewardMenuOnPlayerJoin = builder.comment("Shows the rewards menu when a player joins the server (if there are unclaimed rewards).").define("showRewardMenuOnPlayerJoin", false);
            builder.pop();
            builder.push("Fill Items");
            this.useFillItems = builder.comment("Use fill items if there are not enough valid items for a month. (e.g. if there are only 2 items for a month and the player claims 3 rewards, the 3rd reward will be a fill item)").define("useFillItems", true);
            this.normalFillItems = builder.comment("List of normal fill items which are used in the case we have not enough valid items for a month.").define("normalFillItems", new ArrayList<String>(Arrays.asList("minecraft:cooked_beef:16", "minecraft:iron_ingot:8", "minecraft:oak_log:16", "minecraft:white_wool:4", "minecraft:gold_ingot:8", "minecraft:wheat_seeds:16", "minecraft:pumpkin_seeds:16", "minecraft:melon_seeds:16", "minecraft:beetroot_seeds:16", "minecraft:arrow:32")));
            this.rareFillItems = builder.comment("List of rare fill items which are used in the case we have not enough valid items for a month.").define("rareFillItems", new ArrayList<String>(Arrays.asList("minecraft:diamond", "minecraft:quartz:3", "minecraft:spyglass")));
            this.rareFillItemsChance = builder.comment("The chance to use a rare item instead of a regular one. e.g. 7 means every 7th items could be a rare item. (0 = disabled)").defineInRange("rareFillItemsChance", 7, 0, 100);
            this.lootBagFillItems = builder.comment("List of loot bag fill items which are used in the case we have not enough valid items for a month.").define("lootBagFillItems", new ArrayList<String>(Arrays.asList("lootbagmod:lootbag")));
            this.lootBagFillItemsChance = builder.comment("The chance to use a loot bag item instead of a regular one. e.g. 15 means every 15th items could be a loot bag item. (0 = disabled)").defineInRange("lootBagFillItemsChance", 15, 0, 100);
            builder.pop();
            builder.push("Rewards Items");
            this.shuffleRewardsItems = builder.comment("Shuffle the rewards items instead of using the defined order.").define("shuffleRewardsItems", true);
            this.rewardsJanuaryItems = builder.comment("List of rewards items for January.").define("rewardsJanuaryItems", new ArrayList<String>(Arrays.asList("minecraft:oak_log:32", "minecraft:cooked_salmon:16", "minecraft:white_wool:16", "minecraft:cake:1")));
            this.rewardsFebruaryItems = builder.comment("List of rewards items for February.").define("rewardsFebruaryItems", new ArrayList<String>(Arrays.asList(new String[0])));
            this.rewardsMarchItems = builder.comment("List of rewards items for March.").define("rewardsMarchItems", new ArrayList<String>(Arrays.asList(new String[0])));
            this.rewardsAprilItems = builder.comment("List of rewards items for April.").define("rewardsAprilItems", new ArrayList<String>(Arrays.asList(new String[0])));
            this.rewardsMayItems = builder.comment("List of rewards items for May.").define("rewardsMayItems", new ArrayList<String>(Arrays.asList("minecraft:egg:16")));
            this.rewardsJuneItems = builder.comment("List of rewards items for June.").define("rewardsJuneItems", new ArrayList<String>(Arrays.asList(new String[0])));
            this.rewardsJulyItems = builder.comment("List of rewards items for July.").define("rewardsJulyItems", new ArrayList<String>(Arrays.asList(new String[0])));
            this.rewardsAugustItems = builder.comment("List of rewards items for August.").define("rewardsAugustItems", new ArrayList<String>(Arrays.asList(new String[0])));
            this.rewardsSeptemberItems = builder.comment("List of rewards items for September.").define("rewardsSeptemberItems", new ArrayList<String>(Arrays.asList(new String[0])));
            this.rewardsOctoberItems = builder.comment("List of rewards items for October.").define("rewardsOctoberItems", new ArrayList<String>(Arrays.asList(new String[0])));
            this.rewardsNovemberItems = builder.comment("List of rewards items for November.").define("rewardsNovemberItems", new ArrayList<String>(Arrays.asList(new String[0])));
            this.rewardsDecemberItems = builder.comment("List of rewards items for December.").define("rewardsDecemberItems", new ArrayList<String>(Arrays.asList("minecraft:firework_rocket:32")));
            builder.pop();
        }
    }
}

