/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.dailyrewards.rewards;

import de.markusbordihn.dailyrewards.config.CommonConfig;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class Rewards {
    protected static final Logger log = LogManager.getLogger((String)"Daily Rewards");
    protected static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    protected static final Random random = new Random();

    protected Rewards() {
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        if (Boolean.TRUE.equals(Rewards.COMMON.useFillItems.get())) {
            log.info("Will use the following normal fill items: {}", Rewards.getNormalFillItems());
            log.info("Will use the following rare fill items: {}", Rewards.getRareFillItems());
        } else {
            log.info("Fill items are disabled, will use only reward items.");
        }
    }

    public static List<ItemStack> calculateRewardItemsForMonth(int month) {
        YearMonth yearMonth = YearMonth.of(Rewards.getCurrentYear(), month);
        int numberOfDays = yearMonth.lengthOfMonth();
        log.info("Calculate Reward items for month {} with {} days ...", (Object)month, (Object)numberOfDays);
        List<ItemStack> rewardItemsForMonth = Rewards.getRewardItemForMonth(month);
        if (Boolean.TRUE.equals((Boolean)Rewards.COMMON.useFillItems.get() == false) || rewardItemsForMonth.size() >= numberOfDays) {
            if (Boolean.FALSE.equals(Rewards.COMMON.useFillItems.get())) {
                log.info("Fill items are disabled, will use {} reward items for month {} with {} days ...", (Object)rewardItemsForMonth.size(), (Object)month, (Object)numberOfDays);
            } else {
                log.info("Found {} reward items for month {} with {} days ...", (Object)rewardItemsForMonth.size(), (Object)month, (Object)numberOfDays);
            }
            List<ItemStack> rewardItems = rewardItemsForMonth.stream().limit(numberOfDays).collect(Collectors.toList());
            if (Boolean.TRUE.equals(Rewards.COMMON.shuffleRewardsItems.get())) {
                log.info("Shuffle reward items for month {} ...", (Object)month);
                Collections.shuffle(rewardItems);
            }
            return rewardItems;
        }
        int numRewardItems = rewardItemsForMonth.size();
        int numMissingRewardItems = numberOfDays - numRewardItems;
        List<ItemStack> normalFillItems = Rewards.getNormalFillItems();
        List<ItemStack> rareFillItems = Rewards.getRareFillItems();
        List<ItemStack> lootBagFillItems = Rewards.getLootBagFillItems();
        HashSet<ItemStack> rareDuplicates = new HashSet<ItemStack>();
        HashSet<ItemStack> lootBagDuplicates = new HashSet<ItemStack>();
        int rareFillItemsChance = rareFillItems.isEmpty() ? 0 : (Integer)Rewards.COMMON.rareFillItemsChance.get();
        int lootBackFillItemChance = lootBagFillItems.isEmpty() ? 0 : (Integer)Rewards.COMMON.lootBagFillItemsChance.get();
        log.warn("Found {} missing days without any items, will try to use fill items ...", (Object)numMissingRewardItems);
        for (int i = 0; i < numMissingRewardItems; ++i) {
            ItemStack lootBagFillItem;
            ItemStack fillItem = null;
            if (rareFillItemsChance > 0 && random.nextInt(rareFillItemsChance) == 0) {
                ItemStack rareFillItem = rareFillItems.get(random.nextInt(rareFillItems.size()));
                if (!rareDuplicates.contains(rareFillItem)) {
                    fillItem = rareFillItem;
                    rareDuplicates.add(rareFillItem);
                }
            } else if (lootBackFillItemChance > 0 && random.nextInt(lootBackFillItemChance) == 0 && !lootBagDuplicates.contains(lootBagFillItem = lootBagFillItems.get(random.nextInt(lootBagFillItems.size())))) {
                fillItem = lootBagFillItem;
                lootBagDuplicates.add(lootBagFillItem);
            }
            if (fillItem == null) {
                if (!normalFillItems.isEmpty()) {
                    fillItem = normalFillItems.get(random.nextInt(normalFillItems.size()));
                } else {
                    log.error("Unable to find any fill item for {} of {} missing days, will use {} instead!", (Object)(i + 1), (Object)numMissingRewardItems, (Object)Items.f_42329_);
                    fillItem = new ItemStack((ItemLike)Items.f_42329_);
                }
            }
            rewardItemsForMonth.add(fillItem);
        }
        if (Boolean.TRUE.equals(Rewards.COMMON.shuffleRewardsItems.get())) {
            log.info("Shuffle reward items for month {} ...", (Object)month);
            Collections.shuffle(rewardItemsForMonth);
        }
        return rewardItemsForMonth;
    }

    public static List<ItemStack> getRewardItemForMonth(int month) {
        switch (month) {
            case 1: {
                return Rewards.parseConfigItems((List)Rewards.COMMON.rewardsJanuaryItems.get());
            }
            case 2: {
                return Rewards.parseConfigItems((List)Rewards.COMMON.rewardsFebruaryItems.get());
            }
            case 3: {
                return Rewards.parseConfigItems((List)Rewards.COMMON.rewardsMarchItems.get());
            }
            case 4: {
                return Rewards.parseConfigItems((List)Rewards.COMMON.rewardsAprilItems.get());
            }
            case 5: {
                return Rewards.parseConfigItems((List)Rewards.COMMON.rewardsMayItems.get());
            }
            case 6: {
                return Rewards.parseConfigItems((List)Rewards.COMMON.rewardsJuneItems.get());
            }
            case 7: {
                return Rewards.parseConfigItems((List)Rewards.COMMON.rewardsJulyItems.get());
            }
            case 8: {
                return Rewards.parseConfigItems((List)Rewards.COMMON.rewardsAugustItems.get());
            }
            case 9: {
                return Rewards.parseConfigItems((List)Rewards.COMMON.rewardsSeptemberItems.get());
            }
            case 10: {
                return Rewards.parseConfigItems((List)Rewards.COMMON.rewardsOctoberItems.get());
            }
            case 11: {
                return Rewards.parseConfigItems((List)Rewards.COMMON.rewardsNovemberItems.get());
            }
            case 12: {
                return Rewards.parseConfigItems((List)Rewards.COMMON.rewardsDecemberItems.get());
            }
        }
        return new ArrayList<ItemStack>();
    }

    public static List<ItemStack> getNormalFillItems() {
        return Rewards.parseConfigItems((List)Rewards.COMMON.normalFillItems.get());
    }

    public static ItemStack getNormalFillItem() {
        List<ItemStack> normalFillItems = Rewards.getNormalFillItems();
        return normalFillItems.get(random.nextInt(normalFillItems.size()));
    }

    public static List<ItemStack> getRareFillItems() {
        return Rewards.parseConfigItems((List)Rewards.COMMON.rareFillItems.get());
    }

    public static ItemStack getRareFillItem() {
        List<ItemStack> rareFillItems = Rewards.getRareFillItems();
        return rareFillItems.get(random.nextInt(rareFillItems.size()));
    }

    public static List<ItemStack> getLootBagFillItems() {
        return Rewards.parseConfigItems((List)Rewards.COMMON.lootBagFillItems.get());
    }

    public static ItemStack getLootBagFillItem() {
        List<ItemStack> lootBagFillItems = Rewards.getRareFillItems();
        return lootBagFillItems.get(random.nextInt(lootBagFillItems.size()));
    }

    public static int getCurrentDay() {
        return LocalDate.now().getDayOfMonth();
    }

    public static int getCurrentMonth() {
        return LocalDate.now().getMonthValue();
    }

    public static int getCurrentYear() {
        return LocalDate.now().getYear();
    }

    public static String getCurrentYearMonthDay() {
        return Rewards.getCurrentYear() + "-" + Rewards.getCurrentMonth() + "-" + Rewards.getCurrentDay();
    }

    public static int getDaysCurrentMonth() {
        YearMonth yearMonth = YearMonth.of(Rewards.getCurrentYear(), Rewards.getCurrentMonth());
        return yearMonth.lengthOfMonth();
    }

    public static int getDaysLeftCurrentMonth() {
        return Rewards.getDaysCurrentMonth() - Rewards.getCurrentDay();
    }

    public static List<ItemStack> parseConfigItems(List<String> configItems) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (String configItem : configItems) {
            Item item;
            Object itemName = configItem;
            int itemCount = 1;
            if (configItem.chars().filter(delimiter -> delimiter == 58).count() == 2L) {
                String[] itemParts = configItem.split(":");
                itemName = itemParts[0] + ":" + itemParts[1];
                itemCount = Integer.parseInt(itemParts[2]);
            }
            if ((item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)itemName))) == null || item == Items.f_41852_) {
                log.warn("Unable to find reward item {} in the registry!", itemName);
                continue;
            }
            ItemStack itemStack = new ItemStack((ItemLike)item);
            itemStack.m_41764_(itemCount);
            items.add(itemStack);
        }
        return items;
    }
}

