/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.domesticationinnovation.client.render;

import com.github.alexthe668.domesticationinnovation.DomesticationMod;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class OreColorRegistry {
    public static final BlockState FALLBACK_BLOCK = Blocks.f_49996_.m_49966_();
    public static Map<String, Integer> TEXTURES_TO_COLOR = new HashMap<String, Integer>();

    public static int getBlockColor(BlockState stack) {
        String blockName = stack.toString();
        if (TEXTURES_TO_COLOR.get(blockName) != null) {
            return TEXTURES_TO_COLOR.get(blockName);
        }
        int colorizer = -1;
        try {
            colorizer = Minecraft.m_91087_().m_91298_().m_92577_(stack, null, null, 0);
        }
        catch (Exception e) {
            DomesticationMod.LOGGER.warn("Another mod did not use block colorizers correctly.");
        }
        int color = 0xFFFFFF;
        if (colorizer == -1) {
            Object texture = null;
            try {
                Color texColour = OreColorRegistry.getAverageColour(OreColorRegistry.getTextureAtlas(stack));
                color = texColour.getRGB();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        } else {
            color = colorizer;
        }
        TEXTURES_TO_COLOR.put(blockName, color);
        return color;
    }

    private static Color getAverageColour(TextureAtlasSprite image) {
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        float count = 0.0f;
        int uMax = image.m_118405_();
        int vMax = image.m_118408_();
        for (float i = 0.0f; i < (float)uMax; i += 1.0f) {
            for (float j = 0.0f; j < (float)vMax; j += 1.0f) {
                float localBlue;
                float localGreen;
                float localRed;
                int alpha = image.getPixelRGBA(0, (int)i, (int)j) >> 24 & 0xFF;
                if (alpha == 0 || Math.abs(Math.max(localRed = (float)(image.getPixelRGBA(0, (int)i, (int)j) >> 0 & 0xFF), Math.max(localGreen = (float)(image.getPixelRGBA(0, (int)i, (int)j) >> 8 & 0xFF), localBlue = (float)(image.getPixelRGBA(0, (int)i, (int)j) >> 16 & 0xFF))) - Math.min(localRed, Math.min(localGreen, localBlue))) < 10.0f) continue;
                red += localRed;
                green += localGreen;
                blue += localBlue;
                count += 1.0f;
            }
        }
        return new Color((int)(red / count), (int)(green / count), (int)(blue / count));
    }

    private static TextureAtlasSprite getTextureAtlas(BlockState state) {
        return Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(state).m_6160_();
    }
}

