/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.domesticationinnovation.server.block;

import com.github.alexthe666.citadel.server.entity.IComandableMob;
import com.github.alexthe668.domesticationinnovation.DomesticationMod;
import com.github.alexthe668.domesticationinnovation.server.block.DITileEntityRegistry;
import com.github.alexthe668.domesticationinnovation.server.block.PetBedBlock;
import com.github.alexthe668.domesticationinnovation.server.entity.TameableUtils;
import com.github.alexthe668.domesticationinnovation.server.misc.DIWorldData;
import com.github.alexthe668.domesticationinnovation.server.misc.RespawnRequest;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PetBedBlockEntity
extends BlockEntity {
    public PetBedBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)DITileEntityRegistry.PET_BED.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PetBedBlockEntity blockEntity) {
        DIWorldData data;
        long time = level.m_8044_() % 24000L;
        if (time == 1L && (data = DIWorldData.get(level)) != null) {
            List<RespawnRequest> requestList = data.getRespawnRequestsFor(level, pos);
            for (RespawnRequest request : requestList) {
                if (!PetBedBlockEntity.addAndRemoveEntity(level, pos, (Direction)state.m_61143_((Property)PetBedBlock.FACING), request)) continue;
                data.removeRespawnRequest(request);
            }
        }
    }

    public void removeAllRequestsFor(@Nullable Player message) {
        DIWorldData data = DIWorldData.get(this.f_58857_);
        if (data != null) {
            List<RespawnRequest> requestList = data.getRespawnRequestsFor(this.f_58857_, this.m_58899_());
            for (RespawnRequest request : requestList) {
                data.removeRespawnRequest(request);
                if (message == null) continue;
                message.m_5661_((Component)Component.m_237110_((String)"message.domesticationinnovation.goodbye", (Object[])new Object[]{request.getNametag()}), false);
            }
        }
    }

    private static boolean addAndRemoveEntity(Level level, BlockPos pos, Direction dir, RespawnRequest request) {
        Entity entity;
        EntityType type = request.getEntityType();
        if (type != null && ((Boolean)DomesticationMod.CONFIG.petBedRespawns.get()).booleanValue() && (entity = type.m_20615_(level)) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.m_7378_(request.getEntityData());
            living.m_146884_(Vec3.m_82514_((Vec3i)pos, (double)0.8f));
            living.m_21153_(living.m_21233_());
            if (!request.getNametag().isEmpty()) {
                living.m_6593_((Component)Component.m_237115_((String)request.getNametag()));
            }
            switch (dir) {
                case NORTH: {
                    living.m_146922_(180.0f);
                    break;
                }
                case EAST: {
                    living.m_146922_(-90.0f);
                    break;
                }
                case SOUTH: {
                    living.m_146922_(0.0f);
                    break;
                }
                case WEST: {
                    living.m_146922_(90.0f);
                }
            }
            if (living instanceof IComandableMob) {
                ((IComandableMob)living).setCommand(1);
            }
            if (living instanceof TamableAnimal) {
                ((TamableAnimal)living).m_21839_(true);
            }
            level.m_7967_((Entity)living);
            Entity owner = TameableUtils.getOwnerOf(entity);
            if (owner instanceof Player) {
                ((Player)owner).m_5661_((Component)Component.m_237110_((String)"message.domesticationinnovation.respawn", (Object[])new Object[]{entity.m_7755_()}), false);
            }
            return true;
        }
        return false;
    }

    public void resetBedsForNearbyPets() {
        Predicate<Entity> pet = animal -> TameableUtils.isTamed(animal) && TameableUtils.getPetBedPos((LivingEntity)animal) != null && TameableUtils.getPetBedPos((LivingEntity)animal).equals((Object)this.m_58899_());
        List list = this.f_58857_.m_6443_(LivingEntity.class, new AABB(this.m_58899_().m_7918_(-10, -5, -10), this.m_58899_().m_7918_(10, 5, 10)), EntitySelector.f_20408_.and(pet));
        for (LivingEntity entity : list) {
            Entity owner = TameableUtils.getOwnerOf((Entity)entity);
            if (!(owner instanceof Player)) continue;
            ((Player)owner).m_5661_((Component)Component.m_237110_((String)"message.domesticationinnovation.remove_respawn", (Object[])new Object[]{entity.m_7755_()}), false);
            TameableUtils.removePetBedPos(entity);
        }
    }
}

