/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.domesticationinnovation.server.misc;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;

public class LanternRequest {
    private String entityType;
    private long timestamp;
    private String nametag;
    private UUID petUUID;
    private UUID ownerUUID;
    private BlockPos chunkPosition;

    public LanternRequest(UUID petUUID, String entityType, UUID ownerUUID, BlockPos chunkPosition, long timestamp, String nametag) {
        this.petUUID = petUUID;
        this.entityType = entityType;
        this.chunkPosition = chunkPosition;
        this.ownerUUID = ownerUUID;
        this.timestamp = timestamp;
        this.nametag = nametag;
    }

    public UUID getPetUUID() {
        return this.petUUID;
    }

    public String getEntityTypeLoc() {
        return this.entityType;
    }

    public EntityType getEntityType() {
        return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(this.entityType));
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getNametag() {
        return this.nametag;
    }

    public BlockPos getChunkPosition() {
        return this.chunkPosition;
    }

    public String toString() {
        if (this.getNametag() == null || this.getNametag().isEmpty()) {
            return this.entityType;
        }
        return this.getNametag() + "|" + this.entityType;
    }
}

