/*
 * Decompiled with CFR 0.152.
 */
package ellemes.container_library.api.v2;

import ellemes.container_library.CommonMain;
import ellemes.container_library.api.v2.OpenableBlockEntityV2;
import ellemes.container_library.api.v2.client.NCL_ClientApiV2;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public interface OpenableBlockEntityProviderV2 {
    default public OpenableBlockEntityV2 getOpenableBlockEntity(Level world, BlockState state, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof OpenableBlockEntityV2) {
            OpenableBlockEntityV2 entity = (OpenableBlockEntityV2)blockEntity;
            return entity;
        }
        return null;
    }

    default public void onInitialOpen(ServerPlayer player) {
    }

    default public InteractionResult ncl_onBlockUse(Level world, BlockState state, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.m_5776_()) {
            return this.ncl_cOpenInventory(pos, hand, hit) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.ncl_sOpenInventory(world, state, pos, serverPlayer);
        }
        return InteractionResult.CONSUME;
    }

    default public boolean ncl_cOpenInventory(BlockPos pos, InteractionHand hand, BlockHitResult hit) {
        return NCL_ClientApiV2.openInventoryAt(pos, hand, hit, false);
    }

    default public boolean ncl_cOpenInventoryNoScreenCheck(BlockPos pos, InteractionHand hand, BlockHitResult hit) {
        return NCL_ClientApiV2.openInventoryAt(pos, hand, hit, true);
    }

    default public void ncl_sOpenInventory(Level world, BlockState state, BlockPos pos, ServerPlayer player) {
        this.ncl_sOpenInventory(world, state, pos, player, null);
    }

    default public void ncl_sOpenInventory(Level world, BlockState state, BlockPos pos, ServerPlayer player, ResourceLocation forcedScreenType) {
        CommonMain.getNetworkWrapper().s_openInventory(player, this.getOpenableBlockEntity(world, state, pos), this::onInitialOpen, pos, forcedScreenType);
    }
}

