/*
 * Decompiled with CFR 0.152.
 */
package ellemes.container_library.api.v3.client;

import ellemes.container_library.CommonClient;
import ellemes.container_library.CommonMain;
import ellemes.container_library.api.client.gui.AbstractScreen;
import ellemes.container_library.api.v3.OpenableInventoryProvider;
import ellemes.container_library.client.gui.PickScreen;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public class ScreenOpeningApi {
    private ScreenOpeningApi() {
        throw new IllegalStateException("ScreenOpeningApi should not be instantiated.");
    }

    public static Screen createTypeSelectScreen(@NotNull Supplier<Screen> returnToScreen) {
        Objects.requireNonNull(returnToScreen, "returnToScreen must not be null, pass () -> null instead.");
        return new PickScreen(returnToScreen);
    }

    public static void openBlockInventory(@NotNull BlockPos pos) {
        Objects.requireNonNull(pos, "pos must not be null");
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            Level world = player.m_9236_();
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            if (block instanceof OpenableInventoryProvider) {
                OpenableInventoryProvider provider = (OpenableInventoryProvider)block;
                ScreenOpeningApi.commonCode(provider, () -> CommonMain.getNetworkWrapper().c_openBlockInventory(pos));
                return;
            }
            throw new IllegalArgumentException("Block must be an OpenableInventoryProvider.");
        }
        throw new IllegalStateException("Not in world?");
    }

    public static void openEntityInventory(@NotNull Entity entity) {
        Objects.requireNonNull(entity, "entity must not be null");
        if (entity instanceof OpenableInventoryProvider) {
            OpenableInventoryProvider provider = (OpenableInventoryProvider)entity;
            ScreenOpeningApi.commonCode(provider, () -> CommonMain.getNetworkWrapper().c_openEntityInventory(entity));
            return;
        }
        throw new IllegalArgumentException("Entity must be an OpenableInventoryProvider.");
    }

    private static void commonCode(OpenableInventoryProvider<?> provider, Runnable runnable) {
        if (provider.getForcedScreenType() == null && !AbstractScreen.isScreenTypeDeclared(CommonClient.getConfigWrapper().getPreferredScreenType())) {
            Minecraft client = Minecraft.m_91087_();
            client.m_91152_((Screen)new PickScreen(runnable));
            return;
        }
        runnable.run();
    }
}

