/*
 * Decompiled with CFR 0.152.
 */
package ellemes.container_library.forge.wrappers;

import ellemes.container_library.CommonMain;
import ellemes.container_library.Utils;
import ellemes.container_library.forge.OpenInventoryMessage;
import ellemes.container_library.inventory.ServerScreenHandlerFactory;
import ellemes.container_library.wrappers.NetworkWrapper;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.Nullable;

public final class ForgeNetworkWrapper
extends NetworkWrapper {
    private final SimpleChannel channel;

    public ForgeNetworkWrapper() {
        String channelVersion = "1.0";
        this.channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)Utils.id("channel")).networkProtocolVersion(() -> channelVersion).clientAcceptedVersions(channelVersion::equals).serverAcceptedVersions(channelVersion::equals).simpleChannel();
        this.channel.messageBuilder(OpenInventoryMessage.class, 0, NetworkDirection.PLAY_TO_SERVER).encoder(OpenInventoryMessage::encode).decoder(OpenInventoryMessage::decode).consumerNetworkThread(this::handleForgeMessage).add();
    }

    private void handleForgeMessage(OpenInventoryMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        ServerPlayer sender = contextSupplier.get().getSender();
        FriendlyByteBuf buffer = message.getData();
        contextSupplier.get().enqueueWork(() -> this.s_handleOpenInventory(sender, buffer));
        contextSupplier.get().setPacketHandled(true);
    }

    @Override
    protected void openScreenHandler(ServerPlayer player, final Container inventory, final ServerScreenHandlerFactory factory, final Component title, ResourceLocation forcedScreenType) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return title;
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int syncId, Inventory playerInventory, Player player) {
                return factory.create(syncId, inventory, playerInventory);
            }
        }, buffer -> {
            buffer.writeInt(inventory.m_6643_());
            if (forcedScreenType != null) {
                buffer.m_130085_(forcedScreenType);
            }
        });
    }

    @Override
    public void c_openBlockInventory(BlockPos pos) {
        this.channel.sendToServer((Object)new OpenInventoryMessage(buffer -> CommonMain.getNetworkWrapper().writeBlockData((FriendlyByteBuf)buffer, pos)));
    }

    @Override
    public void c_openEntityInventory(Entity entity) {
        this.channel.sendToServer((Object)new OpenInventoryMessage(buffer -> CommonMain.getNetworkWrapper().writeEntityData((FriendlyByteBuf)buffer, entity)));
    }

    @Override
    public boolean canOpenInventory(ServerPlayer player, BlockPos pos) {
        return true;
    }
}

