/*
 * Decompiled with CFR 0.152.
 */
package ellemes.container_library.wrappers;

import ellemes.container_library.Utils;
import ellemes.container_library.api.inventory.AbstractHandler;
import ellemes.container_library.api.v2.OpenableBlockEntityV2;
import ellemes.container_library.api.v3.OpenableInventory;
import ellemes.container_library.api.v3.OpenableInventoryProvider;
import ellemes.container_library.api.v3.context.BaseContext;
import ellemes.container_library.api.v3.context.BlockContext;
import ellemes.container_library.inventory.ServerScreenHandlerFactory;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;

public abstract class NetworkWrapper {
    protected abstract void openScreenHandler(ServerPlayer var1, Container var2, ServerScreenHandlerFactory var3, Component var4, ResourceLocation var5);

    public abstract void c_openBlockInventory(BlockPos var1);

    public final void writeBlockData(FriendlyByteBuf buffer, BlockPos pos) {
        buffer.m_130085_(Utils.id("block"));
        buffer.m_130064_(pos);
    }

    public abstract void c_openEntityInventory(Entity var1);

    public final void writeEntityData(FriendlyByteBuf buffer, Entity entity) {
        buffer.m_130085_(Utils.id("entity"));
        buffer.m_130077_(entity.m_20148_());
    }

    public void s_handleOpenInventory(ServerPlayer sender, FriendlyByteBuf buffer) {
        OpenableInventory inventory;
        ResourceLocation context = buffer.m_130281_();
        ServerLevel level = sender.m_9236_();
        BaseContext inventoryContext = null;
        OpenableInventoryProvider inventoryProvider = null;
        switch (context.m_135815_()) {
            case "block": {
                Block block;
                BlockPos pos = buffer.m_130135_();
                if (!this.canOpenInventory(sender, pos) || !((block = level.m_8055_(pos).m_60734_()) instanceof OpenableInventoryProvider)) break;
                OpenableInventoryProvider provider = (OpenableInventoryProvider)block;
                inventoryContext = new BlockContext(level, sender, pos);
                inventoryProvider = provider;
                break;
            }
            case "entity": {
                Entity entity = level.m_8791_(buffer.m_130259_());
                if (!(entity instanceof OpenableInventoryProvider)) break;
                OpenableInventoryProvider provider = (OpenableInventoryProvider)entity;
                inventoryContext = new BaseContext(level, sender);
                inventoryProvider = provider;
            }
        }
        if (inventoryProvider != null && (inventory = inventoryProvider.getOpenableInventory(inventoryContext)) != null) {
            this.s_openInventory(sender, inventory, inventoryProvider::onInitialOpen, inventoryProvider.getForcedScreenType());
        }
        buffer.release();
    }

    private void s_openInventory(ServerPlayer player, OpenableInventory inventory, Consumer<ServerPlayer> onInitialOpen, ResourceLocation forcedScreenType) {
        Component title = inventory.getInventoryTitle();
        if (!inventory.canBeUsedBy(player)) {
            player.m_5661_((Component)Component.m_237110_((String)"container.isLocked", (Object[])new Object[]{title}), true);
            player.m_6330_(SoundEvents.f_11748_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return;
        }
        if (!player.m_5833_()) {
            onInitialOpen.accept(player);
        }
        this.openScreenHandler(player, inventory.getInventory(), (syncId, inv, playerInv) -> new AbstractHandler(syncId, inv, playerInv, null), title, forcedScreenType);
    }

    public final void s_openInventory(ServerPlayer player, OpenableBlockEntityV2 inventory, Consumer<ServerPlayer> onInitialOpen, BlockPos pos, ResourceLocation forcedScreenType) {
        if (inventory == null) {
            return;
        }
        if (this.canOpenInventory(player, pos)) {
            Component title = inventory.getInventoryTitle();
            if (!inventory.canBeUsedBy(player)) {
                player.m_5661_((Component)Component.m_237110_((String)"container.isLocked", (Object[])new Object[]{title}), true);
                player.m_6330_(SoundEvents.f_11748_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return;
            }
            if (!player.m_5833_()) {
                onInitialOpen.accept(player);
            }
            this.openScreenHandler(player, inventory.getInventory(), (syncId, inv, playerInv) -> new AbstractHandler(syncId, inv, playerInv, null), title, forcedScreenType);
        }
    }

    public abstract boolean canOpenInventory(ServerPlayer var1, BlockPos var2);
}

