/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.enlightened_end.configuration;

import net.minecraftforge.common.ForgeConfigSpec;

public class EnlightenedEndConfigConfiguration {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Boolean> BISMUTH_ORE_GENERATES;
    public static final ForgeConfigSpec.ConfigValue<Boolean> MALACHITE_ORE_GENERATES;
    public static final ForgeConfigSpec.ConfigValue<Boolean> NULLSTONE_LAYER;
    public static final ForgeConfigSpec.ConfigValue<Boolean> NULLSTONE_PATCHES;
    public static final ForgeConfigSpec.ConfigValue<Boolean> OOZE_BREAKING;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ENDERNEATH_RADIATION;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ADAMANTITE_RENEWABILITY;
    public static final ForgeConfigSpec.ConfigValue<Boolean> PORTAL_FLASK;
    public static final ForgeConfigSpec.ConfigValue<Double> BIOME_FREQUENCY;
    public static final ForgeConfigSpec.ConfigValue<Double> ENDERNEATH_TUNNEL;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CHORLOAM_TELEPORTING;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CHORLOAM_GENERATION;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CHORUS_ROOTS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> OOZE_POOLS;
    public static final ForgeConfigSpec.ConfigValue<Double> FATAL_RADIATION_AMOUNT;
    public static final ForgeConfigSpec.ConfigValue<Boolean> HANDHELD_RADIATION;
    public static final ForgeConfigSpec.ConfigValue<Double> MAX_RADIATION;

    static {
        BUILDER.push("Config");
        BISMUTH_ORE_GENERATES = BUILDER.define("Bismuth Ore Generation", true);
        MALACHITE_ORE_GENERATES = BUILDER.define("Malachite Ore Generation", true);
        NULLSTONE_LAYER = BUILDER.define("Nullstone Layers Generation", true);
        NULLSTONE_PATCHES = BUILDER.define("Nullstone Patches Generation", false);
        OOZE_BREAKING = BUILDER.comment("Defines if Ooze will occasionally break some blocks below it").define("Ooze Absorbing", true);
        ENDERNEATH_RADIATION = BUILDER.comment("Defines if radiation is emmited from radiating blocks").define("Radiation Emissions", true);
        ADAMANTITE_RENEWABILITY = BUILDER.comment("Defines whether enduring vines will grow Adamantite Nodes").define("Adamantite Renewability", true);
        PORTAL_FLASK = BUILDER.comment("Defines whether Portal Flasks can capture or place End Portals").define("Portal Flask Capturing", true);
        BIOME_FREQUENCY = BUILDER.comment("Decreasing this value from 0 - 1 will make the generated biomes rarer").define("Biome Frequency", (Object)1.0);
        ENDERNEATH_TUNNEL = BUILDER.comment("The amount of blocks enderneath tunnels will dig upwards before stopping").define("Enderneath Tunnel Limit", (Object)70.0);
        CHORLOAM_TELEPORTING = BUILDER.comment("Defines whether chorloam blocks will teleport the player to nearby chloram blocks").define("Chorloam Teleporting", true);
        CHORLOAM_GENERATION = BUILDER.comment("Defines whether chorloam will generate in patches on the end surface").define("Chorloam Generation", true);
        CHORUS_ROOTS = BUILDER.comment("Defines whether chorus roots will generate").define("Chorus Root Generation", true);
        OOZE_POOLS = BUILDER.comment("Defines whether ooze pools will generate on the end surface").define("Ooze Pool Generation", true);
        FATAL_RADIATION_AMOUNT = BUILDER.comment("Defines the amount of ticks of radiation you have to have before taking damage").define("Fatal Radiation Amount", (Object)12000.0);
        HANDHELD_RADIATION = BUILDER.comment("Defines whether held radioactive items will give off radiation").define("Handheld Radiation", true);
        MAX_RADIATION = BUILDER.comment("Defines the max amount of radiation that a player can have in ticks").define("Max Radiation", (Object)16000.0);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

