/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import cy.jdkdigital.everythingcopper.common.block.entity.CopperChimeBlockEntity;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.WeatheringCopper;

public class CopperChimeRenderer
implements BlockEntityRenderer<CopperChimeBlockEntity> {
    public static final ModelLayerLocation COPPER_CHIME_MAIN_LAYER = new ModelLayerLocation(new ResourceLocation("everythingcopper", "main"), "main");
    public static final Material COPPER_BLOCK_SOURCE = new Material(InventoryMenu.f_39692_, new ResourceLocation("block/copper_block"));
    public static final Material EXPOSED_COPPER_BLOCK_SOURCE = new Material(InventoryMenu.f_39692_, new ResourceLocation("block/exposed_copper"));
    public static final Material WEATHERED_COPPER_BLOCK_SOURCE = new Material(InventoryMenu.f_39692_, new ResourceLocation("block/weathered_copper"));
    public static final Material OXIDIZED_COPPER_BLOCK_SOURCE = new Material(InventoryMenu.f_39692_, new ResourceLocation("block/oxidized_copper"));
    private final ModelPart base;
    private final ModelPart chime1;

    public CopperChimeRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelpart = context.m_173582_(COPPER_CHIME_MAIN_LAYER);
        this.base = modelpart.m_171324_("base");
        this.chime1 = this.base.m_171324_("1");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition base = partdefinition.m_171599_("base", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, -4.0f, 0.0f, 2.0f, 8.0f, 2.0f), PartPose.f_171404_);
        base.m_171599_("1", CubeListBuilder.m_171558_().m_171514_(1, 1).m_171481_(0.0f, -4.0f, 0.0f, 2.0f, 8.0f, 2.0f), PartPose.m_171423_((float)12.0f, (float)8.0f, (float)10.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    public void render(CopperChimeBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        float f = (float)blockEntity.f_58813_ + partialTicks;
        float f1 = 0.0f;
        float f2 = 0.0f;
        if (blockEntity.f_58814_) {
            float f3 = Mth.m_14031_((float)(f / (float)Math.PI)) / (4.0f + f / 3.0f);
            if (blockEntity.f_58815_ == Direction.NORTH) {
                f1 = -f3;
            } else if (blockEntity.f_58815_ == Direction.SOUTH) {
                f1 = f3;
            } else if (blockEntity.f_58815_ == Direction.EAST) {
                f2 = -f3;
            } else if (blockEntity.f_58815_ == Direction.WEST) {
                f2 = f3;
            }
        }
        this.chime1.f_104203_ = f1;
        this.chime1.f_104205_ = f2;
        this.chime1.f_104204_ = blockEntity.facing.equals((Object)Direction.NORTH) ? 90.0f : 0.0f;
        this.chime1.m_104301_(poseStack, switch (blockEntity.weatherState) {
            case WeatheringCopper.WeatherState.EXPOSED -> EXPOSED_COPPER_BLOCK_SOURCE.m_119194_(bufferSource, RenderType::m_110446_);
            case WeatheringCopper.WeatherState.WEATHERED -> WEATHERED_COPPER_BLOCK_SOURCE.m_119194_(bufferSource, RenderType::m_110446_);
            case WeatheringCopper.WeatherState.OXIDIZED -> OXIDIZED_COPPER_BLOCK_SOURCE.m_119194_(bufferSource, RenderType::m_110446_);
            default -> COPPER_BLOCK_SOURCE.m_119194_(bufferSource, RenderType::m_110446_);
        }, light, overlay);
    }
}

