/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.common.block.entity;

import cy.jdkdigital.everythingcopper.common.block.CopperChime;
import cy.jdkdigital.everythingcopper.init.ModBlockEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.BellBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CopperChimeBlockEntity
extends BellBlockEntity {
    private boolean resonating;
    private int resonationTicks;
    public WeatheringCopper.WeatherState weatherState;
    public Direction facing;

    public CopperChimeBlockEntity(BlockPos pos, BlockState blockState) {
        super(pos, blockState);
        Block block = blockState.m_60734_();
        if (block instanceof CopperChime) {
            CopperChime chimeBlock = (CopperChime)block;
            this.weatherState = chimeBlock.weatherState;
            this.facing = (Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        }
    }

    public BlockEntityType<?> m_58903_() {
        return (BlockEntityType)ModBlockEntities.COPPER_CHIME.get();
    }

    private static void tick(Level level, BlockPos pos, BlockState blockState, CopperChimeBlockEntity chimeBlockEntity, ResonationEndAction action) {
        if (chimeBlockEntity.f_58814_) {
            ++chimeBlockEntity.f_58813_;
        }
        if (chimeBlockEntity.f_58813_ >= 50) {
            chimeBlockEntity.f_58814_ = false;
            chimeBlockEntity.f_58813_ = 0;
        }
        if (chimeBlockEntity.f_58813_ >= 5 && chimeBlockEntity.resonationTicks == 0 && CopperChimeBlockEntity.areBeesNearby(pos, chimeBlockEntity.f_58817_)) {
            chimeBlockEntity.resonating = true;
            level.m_5594_(null, pos, SoundEvents.f_11700_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (chimeBlockEntity.resonating) {
            if (chimeBlockEntity.resonationTicks < 40) {
                ++chimeBlockEntity.resonationTicks;
            } else {
                action.run(level, pos, chimeBlockEntity.f_58817_);
                chimeBlockEntity.resonating = false;
            }
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState blockState, CopperChimeBlockEntity blockEntity) {
        CopperChimeBlockEntity.tick(level, pos, blockState, blockEntity, CopperChimeBlockEntity::makeBeesGlow);
    }

    private static boolean areBeesNearby(BlockPos pos, List<LivingEntity> entities) {
        for (LivingEntity livingentity : entities) {
            if (!livingentity.m_6084_() || livingentity.m_213877_() || !pos.m_203195_((Position)livingentity.m_20182_(), 32.0) || !livingentity.m_6095_().m_204039_(EntityTypeTags.f_13122_)) continue;
            return true;
        }
        return false;
    }

    private static void makeBeesGlow(Level level, BlockPos pos, List<LivingEntity> entities) {
        entities.stream().filter(entity -> entity.m_6084_() && !entity.m_213877_() && pos.m_203195_((Position)entity.m_20182_(), 48.0) && entity.m_6095_().m_204039_(EntityTypeTags.f_13122_)).forEach(livingEntity -> livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 120)));
    }

    @FunctionalInterface
    static interface ResonationEndAction {
        public void run(Level var1, BlockPos var2, List<LivingEntity> var3);
    }
}

