/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.common.entity;

import cy.jdkdigital.everythingcopper.common.entity.CopperMinecartChest;
import cy.jdkdigital.everythingcopper.common.entity.CopperMinecartCommandBlock;
import cy.jdkdigital.everythingcopper.common.entity.CopperMinecartFurnace;
import cy.jdkdigital.everythingcopper.common.entity.CopperMinecartHopper;
import cy.jdkdigital.everythingcopper.common.entity.CopperMinecartSpawner;
import cy.jdkdigital.everythingcopper.common.entity.CopperMinecartTNT;
import cy.jdkdigital.everythingcopper.common.entity.IWeatheringEntity;
import cy.jdkdigital.everythingcopper.util.WeatheringUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.level.Level;

public class CopperMinecart
extends Minecart
implements IWeatheringEntity {
    public CopperMinecart(EntityType<?> type, Level level) {
        super(type, level);
    }

    public CopperMinecart(Level level, double x, double y, double z) {
        super(level, x, y, z);
    }

    @Override
    public SynchedEntityData getSyncData() {
        return super.m_20088_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.defineData();
    }

    protected Component m_5677_() {
        String id = (this.isWaxed() ? "waxed_" : "") + this.getAge().name().toLowerCase() + "_copper_minecart";
        return Component.m_237115_((String)this.m_6095_().m_20675_().replace("copper_minecart", id));
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        InteractionResult res = this.itemUse(this.f_19853_, player.m_21120_(hand), player, this.m_20183_());
        if (res.equals((Object)InteractionResult.PASS)) {
            return super.m_6096_(player, hand);
        }
        return res;
    }

    public void m_8119_() {
        if (this.f_19797_ % 369 == 0 && this.canAge() && this.f_19853_.f_46441_.m_188501_() < 0.005688889f) {
            this.setAge(WeatheringUtils.nextState(this.getAge()));
        }
        super.m_8119_();
    }

    protected float m_6041_() {
        return super.m_6041_() * this.speedModifier();
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.saveWeatheredState(tag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.loadWeatheredState(tag);
    }

    public static AbstractMinecart createMinecart(Level level, double x, double y, double z, AbstractMinecart.Type type) {
        if (type.equals((Object)AbstractMinecart.Type.CHEST)) {
            return new CopperMinecartChest(level, x, y, z);
        }
        if (type.equals((Object)AbstractMinecart.Type.FURNACE)) {
            return new CopperMinecartFurnace(level, x, y, z);
        }
        if (type.equals((Object)AbstractMinecart.Type.TNT)) {
            return new CopperMinecartTNT(level, x, y, z);
        }
        if (type.equals((Object)AbstractMinecart.Type.SPAWNER)) {
            return new CopperMinecartSpawner(level, x, y, z);
        }
        if (type.equals((Object)AbstractMinecart.Type.HOPPER)) {
            return new CopperMinecartHopper(level, x, y, z);
        }
        return type == AbstractMinecart.Type.COMMAND_BLOCK ? new CopperMinecartCommandBlock(level, x, y, z) : new CopperMinecart(level, x, y, z);
    }
}

