/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.crafting.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.everythingcopper.EverythingCopper;
import cy.jdkdigital.everythingcopper.common.item.ICopperItem;
import cy.jdkdigital.everythingcopper.init.ModRecipeTypes;
import cy.jdkdigital.everythingcopper.init.ModTags;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class WaxOnRecipe
implements CraftingRecipe {
    public final ResourceLocation id;
    public final Ingredient input;
    public final Ingredient wax;

    public WaxOnRecipe(ResourceLocation id, Ingredient input, Ingredient wax) {
        this.id = id;
        this.input = input;
        this.wax = wax;
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        boolean hasWaxItem = false;
        boolean hasWaxableItem = false;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemStack = inv.m_8020_(j);
            if (itemStack.m_41619_()) continue;
            if (itemStack.m_204117_(ModTags.WAXING_ITEMS)) {
                hasWaxItem = true;
                continue;
            }
            if (this.input.test(itemStack)) {
                hasWaxableItem = true;
                continue;
            }
            if (itemStack.equals(ItemStack.f_41583_)) continue;
            return false;
        }
        return hasWaxItem && hasWaxableItem;
    }

    @Nonnull
    public ItemStack assemble(CraftingContainer inv) {
        ItemStack outputItem = ItemStack.f_41583_;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemStack = inv.m_8020_(j);
            if (itemStack.m_41619_() || !this.input.test(itemStack)) continue;
            outputItem = itemStack.m_41777_();
        }
        ICopperItem.setWaxed(outputItem, true);
        return outputItem;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return this.input.m_43908_().length > 0 ? this.input.m_43908_()[0] : ItemStack.f_41583_;
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_122779_();
        list.add((Object)this.input);
        list.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42784_}));
        return list;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.WAX_ON.get();
    }

    public static class Serializer<T extends WaxOnRecipe>
    implements RecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation id, JsonObject json) {
            Ingredient input = GsonHelper.m_13885_((JsonObject)json, (String)"item") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"item")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"item"));
            Ingredient wax = GsonHelper.m_13885_((JsonObject)json, (String)"wax") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"wax")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"wax"));
            return this.factory.create(id, input, wax);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
            try {
                return this.factory.create(id, Ingredient.m_43940_((FriendlyByteBuf)buffer), Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            catch (Exception e) {
                EverythingCopper.LOGGER.error("Error reading waxing recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, T recipe) {
            try {
                ((WaxOnRecipe)recipe).input.m_43923_(buffer);
                ((WaxOnRecipe)recipe).wax.m_43923_(buffer);
            }
            catch (Exception e) {
                EverythingCopper.LOGGER.error("Error writing waxing recipe to packet. " + ((WaxOnRecipe)recipe).m_6423_(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends WaxOnRecipe> {
            public T create(ResourceLocation var1, Ingredient var2, Ingredient var3);
        }
    }
}

