/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.animation.v2.resource.packresources;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import de.keksuccino.fancymenu.menu.animation.v2.resource.packresources.AnimationPackResources;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.ResourcePackFileNotFoundException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class AnimationZipPackResources
extends AnimationPackResources {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Splitter SPLITTER = Splitter.on((char)'/').omitEmptyStrings().limit(3);
    @Nullable
    private ZipFile zipFile;

    public AnimationZipPackResources(File animationZip) {
        super(animationZip);
    }

    private ZipFile getOrCreateZipFile() throws IOException {
        if (this.zipFile == null) {
            this.zipFile = new ZipFile(this.f_10203_);
        }
        return this.zipFile;
    }

    protected InputStream m_5541_(String path) throws IOException {
        ZipFile zipfile = this.getOrCreateZipFile();
        ZipEntry zipentry = zipfile.getEntry(path);
        if (zipentry == null) {
            throw new ResourcePackFileNotFoundException(this.f_10203_, path);
        }
        return zipfile.getInputStream(zipentry);
    }

    public boolean m_6105_(String path) {
        try {
            return this.getOrCreateZipFile().getEntry(path) != null;
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    public Set<String> m_5698_(PackType packType) {
        ZipFile zipfile;
        try {
            zipfile = this.getOrCreateZipFile();
        }
        catch (IOException ioexception) {
            return Collections.emptySet();
        }
        Enumeration<? extends ZipEntry> enumeration = zipfile.entries();
        HashSet set = Sets.newHashSet();
        while (enumeration.hasMoreElements()) {
            ArrayList list;
            ZipEntry zipentry = enumeration.nextElement();
            String s = zipentry.getName();
            if (!s.startsWith(packType.m_10305_() + "/") || (list = Lists.newArrayList((Iterable)SPLITTER.split((CharSequence)s))).size() <= 1) continue;
            String s1 = (String)list.get(1);
            if (s1.equals(s1.toLowerCase(Locale.ROOT))) {
                set.add(s1);
                continue;
            }
            this.m_10230_(s1);
        }
        return set;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        if (this.zipFile != null) {
            IOUtils.closeQuietly((Closeable)this.zipFile);
            this.zipFile = null;
        }
    }

    public Collection<ResourceLocation> m_214146_(PackType packType, String string, String string2, Predicate<ResourceLocation> predicate) {
        ZipFile zipfile;
        try {
            zipfile = this.getOrCreateZipFile();
        }
        catch (IOException ioexception) {
            return Collections.emptySet();
        }
        Enumeration<? extends ZipEntry> enumeration = zipfile.entries();
        ArrayList list = Lists.newArrayList();
        String s = packType.m_10305_() + "/" + string + "/";
        String s1 = s + string2 + "/";
        while (enumeration.hasMoreElements()) {
            String s2;
            ZipEntry zipentry = enumeration.nextElement();
            if (zipentry.isDirectory() || (s2 = zipentry.getName()).endsWith(".mcmeta") || !s2.startsWith(s1)) continue;
            String s3 = s2.substring(s.length());
            ResourceLocation resourcelocation = ResourceLocation.m_214293_((String)string, (String)s3);
            if (resourcelocation == null) {
                LOGGER.warn("Invalid path in datapack: {}:{}, ignoring", (Object)string, (Object)s3);
                continue;
            }
            if (!predicate.test(resourcelocation)) continue;
            list.add(resourcelocation);
        }
        return list;
    }
}

