/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item.items.playerentity;

import com.mojang.blaze3d.platform.NativeImage;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.resources.SelfcleaningDynamicTexture;
import de.keksuccino.konkrete.resources.TextureHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SkinExternalTextureResourceLocation
extends ExternalTextureResourceLocation {
    private static final Logger LOGGER = LogManager.getLogger();
    protected boolean loaded = false;
    protected String path;
    protected InputStream in;
    protected int width = 0;
    protected int height = 0;
    protected ResourceLocation location;

    public SkinExternalTextureResourceLocation(String path) {
        super(path);
        this.path = path;
    }

    public void loadTexture() {
        if (!this.loaded) {
            try {
                ResourceLocation loc;
                if (Minecraft.m_91087_().m_91097_() == null) {
                    LOGGER.error("[FANCYMENU] Can't load texture '" + this.path + "'! Minecraft TextureManager instance not ready yet!");
                    return;
                }
                ExternalTextureResourceLocation exRL = TextureHandler.getResource((String)this.path);
                if (exRL != null && (loc = exRL.getResourceLocation()) != null && exRL.getHeight() >= 64) {
                    this.width = exRL.getWidth();
                    this.height = exRL.getHeight();
                    this.location = loc;
                    this.loaded = true;
                    return;
                }
                File f = new File(this.path);
                this.in = new FileInputStream(f);
                NativeImage i = NativeImage.m_85058_((InputStream)this.in);
                this.width = i.m_84982_();
                this.height = i.m_85084_();
                if (this.height < 64) {
                    NativeImage skinNew = new NativeImage(64, 64, true);
                    skinNew.m_85054_(i);
                    int xOffsetLeg = 16;
                    int yOffsetLeg = 32;
                    SkinExternalTextureResourceLocation.cloneSkinPart(skinNew, 4, 16, 4, 4, xOffsetLeg, yOffsetLeg, true);
                    SkinExternalTextureResourceLocation.cloneSkinPart(skinNew, 8, 16, 4, 4, xOffsetLeg, yOffsetLeg, true);
                    SkinExternalTextureResourceLocation.cloneSkinPart(skinNew, 0, 20, 4, 12, xOffsetLeg + 8, yOffsetLeg, true);
                    SkinExternalTextureResourceLocation.cloneSkinPart(skinNew, 4, 20, 4, 12, xOffsetLeg, yOffsetLeg, true);
                    SkinExternalTextureResourceLocation.cloneSkinPart(skinNew, 8, 20, 4, 12, xOffsetLeg - 8, yOffsetLeg, true);
                    SkinExternalTextureResourceLocation.cloneSkinPart(skinNew, 12, 20, 4, 12, xOffsetLeg, yOffsetLeg, true);
                    int xOffsetArm = -8;
                    int yOffsetArm = 32;
                    SkinExternalTextureResourceLocation.cloneSkinPart(skinNew, 44, 16, 4, 4, xOffsetArm, yOffsetArm, true);
                    SkinExternalTextureResourceLocation.cloneSkinPart(skinNew, 48, 16, 4, 4, xOffsetArm, yOffsetArm, true);
                    SkinExternalTextureResourceLocation.cloneSkinPart(skinNew, 40, 20, 4, 12, xOffsetArm + 8, yOffsetArm, true);
                    SkinExternalTextureResourceLocation.cloneSkinPart(skinNew, 44, 20, 4, 12, xOffsetArm, yOffsetArm, true);
                    SkinExternalTextureResourceLocation.cloneSkinPart(skinNew, 48, 20, 4, 12, xOffsetArm - 8, yOffsetArm, true);
                    SkinExternalTextureResourceLocation.cloneSkinPart(skinNew, 52, 20, 4, 12, xOffsetArm, yOffsetArm, true);
                    i = skinNew;
                }
                this.location = Minecraft.m_91087_().m_91097_().m_118490_("externaltexture", (DynamicTexture)new SelfcleaningDynamicTexture(i));
                this.loaded = true;
            }
            catch (Exception var2) {
                var2.printStackTrace();
            }
            if (this.in != null) {
                IOUtils.closeQuietly((InputStream)this.in);
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ResourceLocation getResourceLocation() {
        return this.location;
    }

    public boolean isReady() {
        return this.loaded;
    }

    public String getPath() {
        return this.path;
    }

    protected static void copyPixelArea(NativeImage in, int xFrom, int yFrom, int xTo, int yTo, int width, int height, boolean mirrorX) {
        int vertOffset = 0;
        int vertical = yTo;
        while (vertical < yTo + height) {
            int horiOffset = 0;
            if (mirrorX) {
                horiOffset = width - 1;
            }
            int horizontal = xTo;
            while (horizontal < xTo + width) {
                int pixel = in.m_84985_(xFrom + horiOffset, yFrom + vertOffset);
                in.m_84988_(horizontal, vertical, pixel);
                ++horizontal;
                if (mirrorX) {
                    --horiOffset;
                    continue;
                }
                ++horiOffset;
            }
            ++vertical;
            ++vertOffset;
        }
    }

    protected static void cloneSkinPart(NativeImage in, int xStart, int yStart, int width, int height, int xOffset, int yOffset, boolean mirrorX) {
        SkinExternalTextureResourceLocation.copyPixelArea(in, xStart, yStart, xStart + xOffset, yStart + yOffset, width, height, mirrorX);
    }
}

