/*
 * Decompiled with CFR 0.152.
 */
package zed.d0c.floormats.blocks;

import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import zed.d0c.floormats.setup.Registration;

@ParametersAreNonnullByDefault
public abstract class AbstractConnectedBlock
extends Block {
    protected static final Random random = new Random();
    public static final TagKey<Item> CONNECTOR_TAG = ItemTags.create((ResourceLocation)new ResourceLocation("floormats", "connectors"));

    public AbstractConnectedBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BlockStateProperties.f_61366_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BlockStateProperties.f_61367_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(true)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61366_, BlockStateProperties.f_61367_, BlockStateProperties.f_61368_, BlockStateProperties.f_61370_, BlockStateProperties.f_61371_, BlockStateProperties.f_61369_});
    }

    public boolean canConnect(BlockState state) {
        return this.m_7374_().equals(state.m_60734_());
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level blockgetter = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)Objects.requireNonNull(super.m_5573_(context)).m_61124_((Property)BlockStateProperties.f_61366_, (Comparable)Boolean.valueOf(this.canConnect(blockgetter.m_8055_(blockpos.m_7494_()))))).m_61124_((Property)BlockStateProperties.f_61367_, (Comparable)Boolean.valueOf(this.canConnect(blockgetter.m_8055_(blockpos.m_7495_()))))).m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(this.canConnect(blockgetter.m_8055_(blockpos.m_122012_()))))).m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(this.canConnect(blockgetter.m_8055_(blockpos.m_122019_()))))).m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(this.canConnect(blockgetter.m_8055_(blockpos.m_122024_()))))).m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(this.canConnect(blockgetter.m_8055_(blockpos.m_122029_()))));
    }

    @Nonnull
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return (BlockState)stateIn.m_61124_((Property)PipeBlock.f_55154_.get(facing), (Comparable)Boolean.valueOf(facingState.m_60734_() instanceof AbstractConnectedBlock && (Boolean)facingState.m_61143_((Property)PipeBlock.f_55154_.get(facing.m_122424_())) != false));
    }

    @Nonnull
    public InteractionResult m_6227_(BlockState stateIn, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult trace) {
        ItemStack itemInHand;
        ItemStack itemStack = itemInHand = hand == InteractionHand.MAIN_HAND ? player.m_150109_().m_36056_() : (ItemStack)player.m_150109_().f_35976_.get(0);
        if (!worldIn.f_46443_) {
            float pitch = 0.8f / (random.nextFloat() * 0.4f + 0.8f);
            BlockPos iPos = pos.m_7949_();
            if (AbstractConnectedBlock.isConnector(itemInHand.m_41720_())) {
                worldIn.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)Registration.FLOORMATS_WRENCHED.get(), SoundSource.NEUTRAL, 0.5f, pitch);
                Direction direction = this.getDirectionFromQuadrant(pos, trace);
                BooleanProperty directionProperty = (BooleanProperty)PipeBlock.f_55154_.get(direction);
                BlockState newState = (BlockState)stateIn.m_61124_((Property)directionProperty, (Comparable)Boolean.valueOf((Boolean)stateIn.m_61143_((Property)directionProperty) == false));
                worldIn.m_46597_(iPos, newState);
                worldIn.m_6550_(iPos, stateIn, newState);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    private Direction getDirectionFromQuadrant(BlockPos pos, BlockHitResult trace) {
        double hitX = trace.m_82450_().f_82479_ - (double)pos.m_123341_() - 0.5;
        double hitY = trace.m_82450_().f_82480_ - (double)pos.m_123342_() - 0.5;
        double hitZ = trace.m_82450_().f_82481_ - (double)pos.m_123343_() - 0.5;
        return switch (trace.m_82434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP, Direction.DOWN -> {
                if (Math.abs(hitX) > Math.abs(hitZ)) {
                    if (hitX > 0.0) {
                        yield Direction.EAST;
                    }
                    yield Direction.WEST;
                }
                if (hitZ > 0.0) {
                    yield Direction.SOUTH;
                }
                yield Direction.NORTH;
            }
            case Direction.NORTH, Direction.SOUTH -> {
                if (Math.abs(hitX) > Math.abs(hitY)) {
                    if (hitX > 0.0) {
                        yield Direction.EAST;
                    }
                    yield Direction.WEST;
                }
                if (hitY > 0.0) {
                    yield Direction.UP;
                }
                yield Direction.DOWN;
            }
            case Direction.EAST, Direction.WEST -> {
                if (Math.abs(hitY) > Math.abs(hitZ)) {
                    if (hitY > 0.0) {
                        yield Direction.UP;
                    }
                    yield Direction.DOWN;
                }
                yield hitZ > 0.0 ? Direction.SOUTH : Direction.NORTH;
            }
        };
    }

    private static boolean isConnector(Item item) {
        return item.m_7968_().m_204117_(CONNECTOR_TAG);
    }
}

