/*
 * Decompiled with CFR 0.152.
 */
package zed.d0c.floormats.clusters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import zed.d0c.floormats.clusters.ClustersNode;
import zed.d0c.floormats.punchcards.PunchCards;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class Clusters {
    private static final ClustersRegistry CLUSTERS_REGISTRY = new ClustersRegistry();

    public static ClustersRegistry getClustersRegistry() {
        return CLUSTERS_REGISTRY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNode(Level worldIn, ClustersNode newNode) {
        ClustersRegistry clustersRegistry = Clusters.getClustersRegistry();
        synchronized (clustersRegistry) {
            CLUSTERS_REGISTRY.getClusterSet(worldIn).add(newNode);
        }
        PunchCards.setStaticDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNode(Level worldIn, ClustersNode exNode) {
        ClustersRegistry clustersRegistry = Clusters.getClustersRegistry();
        synchronized (clustersRegistry) {
            CLUSTERS_REGISTRY.getClusterSet(worldIn).remove(exNode);
        }
        PunchCards.setStaticDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNodeSet(Level worldIn, ClustersSet newNodeSet) {
        ClustersRegistry clustersRegistry = Clusters.getClustersRegistry();
        synchronized (clustersRegistry) {
            CLUSTERS_REGISTRY.getClusterSet(worldIn).addAll(newNodeSet);
        }
        PunchCards.setStaticDirty();
    }

    private ClustersNode getNode(Level worldIn, BlockState state, BlockPos pos) {
        Block block = state.m_60734_();
        for (ClustersNode node : CLUSTERS_REGISTRY.getClusterSet(worldIn)) {
            if (!node.contains(block, pos)) continue;
            return node;
        }
        ClustersNode newNode = new ClustersNode(state.m_60734_(), pos);
        this.addNode(worldIn, newNode);
        return newNode;
    }

    public boolean hasNode(Level worldIn, BlockState state, BlockPos pos) {
        Block block = state.m_60734_();
        for (ClustersNode node : CLUSTERS_REGISTRY.getClusterSet(worldIn)) {
            if (!node.contains(block, pos)) continue;
            return true;
        }
        return false;
    }

    public boolean applyDirectPower(Level worldIn, BlockPos iPos, @Nullable ArrayList<Player> playerList) {
        ClustersNode node = this.getNode(worldIn, worldIn.m_8055_(iPos), iPos);
        boolean directPowerApplied = node.powerNode(worldIn, iPos, playerList);
        PunchCards.setStaticDirty();
        return directPowerApplied;
    }

    public boolean removeDirectPower(BlockState state, Level worldIn, BlockPos pos) {
        boolean blockDepowered = this.getNode(worldIn, state, pos).depowerBlock(worldIn, pos);
        PunchCards.setStaticDirty();
        return blockDepowered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToClusters(Level worldIn, BlockPos pos, BlockState state) {
        BlockPos iPos = pos.m_7949_();
        Block block = state.m_60734_();
        ClustersNode node = this.getNode(worldIn, state, iPos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            ClustersNode adjacentNode;
            BlockPos neighborPos;
            if (!((Boolean)state.m_61143_((Property)PipeBlock.f_55154_.get(direction))).booleanValue() || worldIn.m_8055_(neighborPos = iPos.m_121945_(direction)).m_60734_() != block || node.equals(adjacentNode = this.getNode(worldIn, state, neighborPos))) continue;
            ClustersRegistry clustersRegistry = Clusters.getClustersRegistry();
            synchronized (clustersRegistry) {
                node.absorbOtherNode(adjacentNode);
                this.removeNode(worldIn, adjacentNode);
            }
        }
        node.powerAsNeeded(worldIn);
        PunchCards.setStaticDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromClusters(Level worldIn, BlockPos iPos, BlockState state) {
        boolean wasPowered = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_);
        ClustersNode thisNode = this.getNode(worldIn, state, iPos);
        int neighborCount = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!((Boolean)state.m_61143_((Property)PipeBlock.f_55154_.get(direction))).booleanValue()) continue;
            ++neighborCount;
        }
        ClustersRegistry clustersRegistry = Clusters.getClustersRegistry();
        synchronized (clustersRegistry) {
            switch (neighborCount) {
                case 0: {
                    thisNode.removeLink(worldIn, wasPowered);
                    this.removeNode(worldIn, thisNode);
                    break;
                }
                case 1: {
                    thisNode.removePos(worldIn, iPos);
                    if (!wasPowered || thisNode.isPowered()) break;
                    thisNode.depowerNode(worldIn);
                    break;
                }
                default: {
                    thisNode.removePos(worldIn, iPos);
                    ClustersSet setOfNodes = thisNode.reformNode(worldIn);
                    this.removeNode(worldIn, thisNode);
                    this.addNodeSet(worldIn, setOfNodes);
                    if (!wasPowered) break;
                    for (ClustersNode nodeForPowerCheck : setOfNodes) {
                        if (nodeForPowerCheck.isPowered()) continue;
                        nodeForPowerCheck.depowerNode(worldIn);
                    }
                }
            }
        }
        PunchCards.setStaticDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterClusters(Level worldIn, BlockPos iPos, BlockState stateIn) {
        ClustersNode node = this.getNode(worldIn, stateIn, iPos);
        boolean wasPowered = node.isPowered();
        ClustersRegistry clustersRegistry = Clusters.getClustersRegistry();
        synchronized (clustersRegistry) {
            ClustersSet setOfNodes = node.reformNode(worldIn);
            this.removeNode(worldIn, node);
            this.addNodeSet(worldIn, setOfNodes);
            if (wasPowered) {
                for (ClustersNode nodeForPowerCheck : setOfNodes) {
                    if (nodeForPowerCheck.isPowered()) continue;
                    nodeForPowerCheck.depowerNode(worldIn);
                }
            }
        }
        PunchCards.setStaticDirty();
    }

    public void registerUniqueID(Level worldIn, BlockPos pos, BlockState state, UUID uniqueID) {
        this.getNode(worldIn, state, pos).addUniqueID(uniqueID);
    }

    public boolean canAlter(Level worldIn, BlockPos pos, BlockState state, UUID uniqueID) {
        return this.getNode(worldIn, state, pos).canAccess(uniqueID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int cmdReset(ServerLevel serverWorld) {
        int correctionCount = 0;
        ClustersRegistry clustersRegistry = Clusters.getClustersRegistry();
        synchronized (clustersRegistry) {
            for (ResourceKey dim : CLUSTERS_REGISTRY.keySet()) {
                ClustersSet emptyNodes = new ClustersSet();
                for (ClustersNode node : (ClustersSet)CLUSTERS_REGISTRY.get(dim)) {
                    correctionCount += node.cmdResetNode(serverWorld);
                    if (!node.isEmpty()) continue;
                    emptyNodes.add(node);
                }
                ((ClustersSet)CLUSTERS_REGISTRY.get(dim)).removeAll(emptyNodes);
            }
        }
        PunchCards.setStaticDirty();
        return correctionCount;
    }

    public boolean linkClusters(Level worldIn, BlockPos iPos, BlockState state, BlockPos linkPos, BlockState linkState) {
        ClustersNode linkNode;
        ClustersNode node = this.getNode(worldIn, state, iPos);
        if (node.equals(linkNode = this.getNode(worldIn, linkState, linkPos))) {
            node.removeLink(worldIn, node.isPowered());
            PunchCards.setStaticDirty();
            return false;
        }
        boolean powered = node.isPowered();
        boolean linkPowered = linkNode.isPowered();
        if (powered && !linkPowered) {
            linkNode.powerNode(worldIn, null, null);
        } else if (linkPowered && !powered) {
            node.powerNode(worldIn, null, null);
        }
        node.linkTo(linkNode);
        PunchCards.setStaticDirty();
        return true;
    }

    public void linkEffects(Level worldIn, BlockPos iPos, BlockState stateIn) {
        this.getNode(worldIn, stateIn, iPos).createLinkEffect(worldIn);
    }

    public boolean hasDirectPower(BlockState state, Level worldIn, BlockPos pos) {
        return this.getNode(worldIn, state, pos).hasDirectPowerMarked(pos);
    }

    public void playOnSound(BlockGetter iWorldIn, BlockPos pos) {
        if (!(iWorldIn instanceof Level)) {
            return;
        }
        Level worldIn = (Level)iWorldIn;
        this.getNode(worldIn, worldIn.m_8055_(pos), pos).playClickOnSound(worldIn, pos);
    }

    public void playOffSound(BlockGetter iWorldIn, BlockPos pos) {
        if (!(iWorldIn instanceof Level)) {
            return;
        }
        Level worldIn = (Level)iWorldIn;
        this.getNode(worldIn, worldIn.m_8055_(pos), pos).playClickOffSound(worldIn, pos);
    }

    public void toggleMuffler(Level worldIn, BlockPos pos) {
        this.getNode(worldIn, worldIn.m_8055_(pos), pos).toggleMuffler();
    }

    public void toggleInverted(Level worldIn, BlockPos pos) {
        this.getNode(worldIn, worldIn.m_8055_(pos), pos).toggleInverted();
    }

    public void clearPlayerList(Level worldIn, BlockPos pos) {
        this.getNode(worldIn, worldIn.m_8055_(pos), pos).clearPlayerList();
    }

    public static class ClustersRegistry
    extends HashMap<ResourceKey<Level>, ClustersSet> {
        private ClustersSet getClusterSet(ResourceKey<Level> key) {
            if (!this.containsKey(key)) {
                this.put(key, new ClustersSet());
            }
            return (ClustersSet)this.get(key);
        }

        private ClustersSet getClusterSet(Level worldIn) {
            ResourceKey key = worldIn.m_46472_();
            return this.getClusterSet((ResourceKey<Level>)key);
        }
    }

    public static class ClustersSet
    extends HashSet<ClustersNode> {
    }
}

