/*
 * Decompiled with CFR 0.152.
 */
package zed.d0c.floormats.punchcards;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.saveddata.SavedData;
import zed.d0c.floormats.clusters.Clusters;
import zed.d0c.floormats.clusters.ClustersNode;

public class PunchCards
extends SavedData {
    private static PunchCards DECK_OF_CARDS;
    private static final String DECK_BOX_NAME = "PUNCH_CARDS_DATA";
    private static final String REGISTRY_NBT_KEY = "Registry";

    public static String getDataName() {
        return DECK_BOX_NAME;
    }

    public static void setInstance(PunchCards pcInstance) {
        DECK_OF_CARDS = pcInstance;
        DECK_OF_CARDS.m_77762_();
    }

    public static void setStaticDirty() {
        if (DECK_OF_CARDS != null) {
            DECK_OF_CARDS.m_77762_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PunchCards load(CompoundTag nbt) {
        Clusters.ClustersRegistry clustersRegistry = Clusters.getClustersRegistry();
        synchronized (clustersRegistry) {
            Clusters.getClustersRegistry().clear();
            CompoundTag registryNBT = nbt.m_128469_(REGISTRY_NBT_KEY);
            for (String dimName : registryNBT.m_128431_()) {
                ResourceKey dimType = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(dimName));
                ListTag clustersList = registryNBT.m_128437_(dimName, 10);
                Clusters.ClustersSet dimRegistry = new Clusters.ClustersSet();
                for (int clustersIndex = 0; clustersIndex < clustersList.size(); ++clustersIndex) {
                    CompoundTag entry = clustersList.m_128728_(clustersIndex);
                    dimRegistry.add(new ClustersNode(entry));
                }
                Clusters.getClustersRegistry().put(dimType, dimRegistry);
            }
        }
        return DECK_OF_CARDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ParametersAreNonnullByDefault
    public CompoundTag m_7176_(CompoundTag nbt) {
        CompoundTag registryNBT = new CompoundTag();
        Clusters.ClustersRegistry clustersRegistry = Clusters.getClustersRegistry();
        synchronized (clustersRegistry) {
            for (ResourceKey dimType : Clusters.getClustersRegistry().keySet()) {
                if (dimType == null) continue;
                ListTag clustersList = new ListTag();
                for (ClustersNode node : (Clusters.ClustersSet)Clusters.getClustersRegistry().get(dimType)) {
                    clustersList.add((Object)node.serializeNBT());
                }
                registryNBT.m_128365_(dimType.m_135782_().toString(), (Tag)clustersList);
            }
        }
        nbt.m_128365_(REGISTRY_NBT_KEY, (Tag)registryNBT);
        return nbt;
    }
}

