/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.incubation.core.registry;

import com.google.common.collect.ImmutableList;
import com.teamabnormals.incubation.common.levelgen.feature.BirdNestFeature;
import com.teamabnormals.incubation.common.levelgen.feature.configurations.NestConfiguration;
import com.teamabnormals.incubation.core.other.IncubationConstants;
import com.teamabnormals.incubation.core.registry.IncubationBlocks;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="incubation", bus=Mod.EventBusSubscriber.Bus.MOD)
public class IncubationFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"incubation");
    public static final RegistryObject<Feature<NestConfiguration>> BIRD_NEST = FEATURES.register("bird_nest", () -> new BirdNestFeature(NestConfiguration.CODEC));

    public static final class IncubationPlacedFeatures {
        public static final DeferredRegister<PlacedFeature> PLACED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_194567_, (String)"incubation");
        public static final RegistryObject<PlacedFeature> NEST_CHICKEN = IncubationPlacedFeatures.register("nest_chicken", IncubationConfiguredFeatures.NEST_CHICKEN, new PlacementModifier[]{RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> NEST_DUCK = IncubationPlacedFeatures.register("nest_duck", IncubationConfiguredFeatures.NEST_DUCK, new PlacementModifier[]{RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> NEST_TURKEY = IncubationPlacedFeatures.register("nest_turkey", IncubationConfiguredFeatures.NEST_TURKEY, new PlacementModifier[]{RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});

        private static RegistryObject<PlacedFeature> register(String name, RegistryObject<? extends ConfiguredFeature<?, ?>> feature, PlacementModifier ... placementModifiers) {
            return PLACED_FEATURES.register(name, () -> new PlacedFeature((Holder)feature.getHolder().get(), (List)ImmutableList.copyOf((Object[])placementModifiers)));
        }
    }

    public static final class IncubationConfiguredFeatures {
        public static final DeferredRegister<ConfiguredFeature<?, ?>> CONFIGURED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_122881_, (String)"incubation");
        public static final RegistryObject<ConfiguredFeature<NestConfiguration, ?>> NEST_CHICKEN = IncubationConfiguredFeatures.register("nest_chicken", () -> new ConfiguredFeature((Feature)BIRD_NEST.get(), (FeatureConfiguration)new NestConfiguration(((Block)IncubationBlocks.TWIG_CHICKEN_NEST.get()).m_49966_(), IncubationConstants.CHICKEN)));
        public static final RegistryObject<ConfiguredFeature<NestConfiguration, ?>> NEST_DUCK = IncubationConfiguredFeatures.register("nest_duck", () -> new ConfiguredFeature((Feature)BIRD_NEST.get(), (FeatureConfiguration)new NestConfiguration(((Block)IncubationBlocks.TWIG_DUCK_NEST.get()).m_49966_(), IncubationConstants.DUCK)));
        public static final RegistryObject<ConfiguredFeature<NestConfiguration, ?>> NEST_TURKEY = IncubationConfiguredFeatures.register("nest_turkey", () -> new ConfiguredFeature((Feature)BIRD_NEST.get(), (FeatureConfiguration)new NestConfiguration(((Block)IncubationBlocks.TWIG_TURKEY_NEST.get()).m_49966_(), IncubationConstants.TURKEY)));

        private static <FC extends FeatureConfiguration, F extends Feature<FC>> RegistryObject<ConfiguredFeature<FC, ?>> register(String name, Supplier<ConfiguredFeature<FC, F>> feature) {
            return CONFIGURED_FEATURES.register(name, feature);
        }
    }
}

