/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.kleeslabs.registry.json;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.kleeslabs.KleeSlabs;
import net.blay09.mods.kleeslabs.KleeSlabsConfig;
import net.blay09.mods.kleeslabs.converter.SlabConverter;
import net.blay09.mods.kleeslabs.registry.SlabRegistry;
import net.blay09.mods.kleeslabs.registry.SlabRegistryData;
import net.blay09.mods.kleeslabs.registry.json.JsonCompatData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class JsonCompatLoader
implements ResourceManagerReloadListener {
    private static final Gson gson = new Gson();

    public void m_6213_(ResourceManager resourceManager) {
        for (Map.Entry entry : resourceManager.m_214159_("kleeslabs_compat", it -> it.m_135815_().endsWith(".json")).entrySet()) {
            try {
                BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                try {
                    JsonCompatLoader.load((JsonCompatData)gson.fromJson((Reader)reader, JsonCompatData.class));
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (Exception e) {
                KleeSlabs.logger.error("Parsing error loading KleeSlabs Data File at {}", entry.getKey(), (Object)e);
            }
        }
    }

    private static boolean isCompatEnabled(String modId) {
        return !KleeSlabsConfig.getActive().disabledCompat.contains(modId);
    }

    private static void load(JsonCompatData data) {
        Map<String, String> mappedSlabs;
        Class<?> converterClass;
        String modId = data.getModId();
        if (!modId.equals("minecraft") && !Balm.isModLoaded((String)modId) || !JsonCompatLoader.isCompatEnabled(modId)) {
            return;
        }
        boolean isSilent = data.isSilent();
        String converterName = data.getConverter();
        try {
            converterClass = Class.forName("net.blay09.mods.kleeslabs.converter." + converterName);
        }
        catch (ClassNotFoundException ignored) {
            try {
                converterClass = Class.forName(converterName);
            }
            catch (ClassNotFoundException e) {
                KleeSlabs.logger.error("Slab converter class was not found: {}", (Object)converterName);
                return;
            }
        }
        if (!SlabConverter.class.isAssignableFrom(converterClass)) {
            KleeSlabs.logger.error("Slab converter class was not found: {}", (Object)converterName);
            return;
        }
        Set<String> slabs = data.getSlabs();
        if (slabs != null) {
            for (String string : slabs) {
                Block block = JsonCompatLoader.parseBlock(modId, string);
                if (block != Blocks.f_50016_) {
                    SlabRegistry.registerSlab(new SlabRegistryData(converterClass, block, block));
                    continue;
                }
                if (isSilent) continue;
                KleeSlabs.logger.error("Slab {}:{} could not be found.", (Object)modId, (Object)string);
            }
        }
        if ((mappedSlabs = data.getMappedSlabs()) != null) {
            for (Map.Entry<String, String> entry : mappedSlabs.entrySet()) {
                String singleSlabName = entry.getKey();
                Block singleSlab = JsonCompatLoader.parseBlock(modId, singleSlabName);
                if (singleSlab == Blocks.f_50016_) {
                    KleeSlabs.logger.error("Slab {}:{} could not be found.", (Object)modId, (Object)singleSlabName);
                    continue;
                }
                String doubleSlabName = entry.getValue();
                Block doubleSlab = JsonCompatLoader.parseBlock(modId, doubleSlabName);
                if (doubleSlab == Blocks.f_50016_) {
                    KleeSlabs.logger.error("Slab {}:{} could not be found.", (Object)modId, (Object)doubleSlabName);
                    continue;
                }
                SlabRegistry.registerSlab(new SlabRegistryData(converterClass, singleSlab, doubleSlab));
            }
        }
        String string = data.getPatternSearch() != null ? data.getPatternSearch() : ".+";
        Pattern pattern = Pattern.compile(string);
        Matcher matcherSearch = pattern.matcher("");
        String patternReplace = data.getPatternReplace() != null ? data.getPatternReplace() : "$0_double";
        Set<String> patternSlabs = data.getPatternSlabs();
        if (patternSlabs != null) {
            for (String singleSlabName : patternSlabs) {
                matcherSearch.reset(singleSlabName);
                String doubleSlabName = matcherSearch.replaceFirst(patternReplace);
                Block singleSlab = JsonCompatLoader.parseBlock(modId, singleSlabName);
                if (singleSlab == Blocks.f_50016_) {
                    KleeSlabs.logger.error("Slab {}:{} could not be found.", (Object)modId, (Object)singleSlabName);
                    continue;
                }
                Block doubleSlab = JsonCompatLoader.parseBlock(modId, doubleSlabName);
                if (doubleSlab == Blocks.f_50016_) {
                    KleeSlabs.logger.error("Slab {}:{} could not be found.", (Object)modId, (Object)doubleSlabName);
                    continue;
                }
                SlabRegistry.registerSlab(new SlabRegistryData(converterClass, singleSlab, doubleSlab));
            }
        }
    }

    private static Block parseBlock(String modId, String name) {
        Block block;
        int colon = name.indexOf(58);
        if (colon != -1) {
            modId = name.substring(0, colon);
            name = name.substring(colon + 1);
        }
        return (block = Balm.getRegistries().getBlock(new ResourceLocation(modId, name))) != null ? block : Blocks.f_50016_;
    }
}

