/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs;

import dev.architectury.platform.Platform;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.util.KubeJSPlugins;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;

public class DevProperties {
    private static DevProperties instance;
    private final Properties properties = new Properties();
    private boolean writeProperties;
    public boolean debugInfo;
    public boolean dataPackOutput = false;
    public boolean logAddedRecipes = false;
    public boolean logRemovedRecipes = false;
    public boolean logModifiedRecipes = false;
    public boolean logSkippedRecipes = false;
    public boolean logSkippedTags = false;
    public boolean logErroringRecipes = true;
    public boolean logInvalidRecipeHandlers = true;
    public boolean logSkippedPlugins = false;
    public boolean strictTags = false;

    public static DevProperties get() {
        if (instance == null) {
            instance = new DevProperties();
        }
        return instance;
    }

    public static void reload() {
        instance = new DevProperties();
    }

    private DevProperties() {
        try {
            Path propertiesFile = KubeJSPaths.getLocalDevProperties();
            this.writeProperties = false;
            if (Files.exists(propertiesFile, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(propertiesFile);){
                    this.properties.load(reader);
                }
            } else {
                this.writeProperties = true;
            }
            this.debugInfo = this.get("debugInfo", Platform.isDevelopmentEnvironment());
            this.dataPackOutput = this.get("dataPackOutput", false);
            this.logAddedRecipes = this.get("logAddedRecipes", false);
            this.logRemovedRecipes = this.get("logRemovedRecipes", false);
            this.logModifiedRecipes = this.get("logModifiedRecipes", false);
            this.logSkippedRecipes = this.get("logSkippedRecipes", false);
            this.logSkippedTags = this.get("logSkippedTags", false);
            this.logErroringRecipes = this.get("logErroringRecipes", true);
            this.logInvalidRecipeHandlers = this.get("logInvalidRecipeHandlers", true);
            this.logSkippedPlugins = this.get("logSkippedPlugins", true);
            this.strictTags = this.get("strictTags", false);
            KubeJSPlugins.forEachPlugin(p -> p.loadDevProperties(this));
            if (this.writeProperties) {
                this.save();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        KubeJS.LOGGER.info("Loaded dev.properties");
    }

    public void remove(String key) {
        String s = this.properties.getProperty(key);
        if (s != null) {
            this.properties.remove(key);
            this.writeProperties = true;
        }
    }

    public String get(String key, String def) {
        String s = this.properties.getProperty(key);
        if (s == null) {
            this.properties.setProperty(key, def);
            this.writeProperties = true;
            return def;
        }
        return s;
    }

    public boolean get(String key, boolean def) {
        return this.get(key, def ? "true" : "false").equals("true");
    }

    public void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(KubeJSPaths.getLocalDevProperties(), new OpenOption[0]);){
            this.properties.store(writer, "KubeJS Dev Properties");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

