/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.script;

import dev.latvian.mods.kubejs.script.ScriptFileInfo;
import dev.latvian.mods.kubejs.script.ScriptPack;
import dev.latvian.mods.kubejs.script.ScriptSource;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class ScriptFile
implements Comparable<ScriptFile> {
    public final ScriptPack pack;
    public final ScriptFileInfo info;
    public final ScriptSource source;

    public ScriptFile(ScriptPack p, ScriptFileInfo i, ScriptSource s) {
        this.pack = p;
        this.info = i;
        this.source = s;
    }

    public void load() throws Throwable {
        try (InputStream stream = this.source.createStream(this.info);){
            String script = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
            this.pack.manager.context.evaluateString(this.pack.scope, script, this.info.location, 1, null);
        }
    }

    @Override
    public int compareTo(ScriptFile o) {
        return Integer.compare(o.info.getPriority(), this.info.getPriority());
    }
}

