/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.set;

import com.google.common.base.Stopwatch;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class BlocksColorInternal {
    public static final List<DyeColor> VANILLA_COLORS = List.of(Arrays.copyOfRange(DyeColor.values(), 0, 16));
    public static final List<DyeColor> MODDED_COLORS = List.of((DyeColor[])Arrays.stream(DyeColor.values()).filter(v -> !VANILLA_COLORS.contains(v)).toArray(DyeColor[]::new));
    private static final Map<String, ColoredSet<Block>> BLOCK_COLOR_SETS = new HashMap<String, ColoredSet<Block>>();
    private static final Map<String, ColoredSet<Item>> ITEM_COLOR_SETS = new HashMap<String, ColoredSet<Item>>();
    private static final Object2ObjectOpenHashMap<Object, DyeColor> BLOCK_TO_COLORS = new Object2ObjectOpenHashMap();
    private static final Object2ObjectOpenHashMap<Object, String> BLOCK_TO_TYPE = new Object2ObjectOpenHashMap();

    public static void setup() {
        Stopwatch sw = Stopwatch.createStarted();
        HashMap<String, DyeColor> colors = new HashMap<String, DyeColor>();
        VANILLA_COLORS.forEach(d -> colors.put(d.m_41065_(), (DyeColor)d));
        ArrayList<String> colorPriority = new ArrayList<String>(colors.keySet().stream().toList());
        BlocksColorInternal.addColoredFromRegistry(colors, colorPriority, Registry.f_122824_, BLOCK_COLOR_SETS);
        BlocksColorInternal.addColoredFromRegistry(colors, colorPriority, Registry.f_122827_, ITEM_COLOR_SETS);
        Moonlight.LOGGER.info("Initialized color sets in {}ms", (Object)sw.elapsed().toMillis());
    }

    public static void registerBlockColorSet(ResourceLocation key, EnumMap<DyeColor, Block> blocks, @Nullable Block defaultBlock) {
        BLOCK_COLOR_SETS.put(key.toString(), new ColoredSet<Block>(key, blocks, (Registry<Block>)Registry.f_122824_, defaultBlock));
    }

    public static void registerItemColorSet(ResourceLocation key, EnumMap<DyeColor, Item> items, @Nullable Item defaultItem) {
        ITEM_COLOR_SETS.put(key.toString(), new ColoredSet<Item>(key, items, (Registry<Item>)Registry.f_122827_, defaultItem));
    }

    private static <T> void addColoredFromRegistry(Map<String, DyeColor> colors, List<String> colorPriority, Registry<T> registry, Map<String, ColoredSet<T>> colorSetMap) {
        HashMap<ResourceLocation, EnumMap> groupedByType = new HashMap<ResourceLocation, EnumMap>();
        colorPriority.sort(Comparator.comparingInt(String::length));
        Collections.reverse(colorPriority);
        block0: for (Object b : registry) {
            ResourceLocation id = Utils.getID(b);
            String name = id.m_135815_();
            if (!name.contains("_")) continue;
            for (String c : colorPriority) {
                ResourceLocation newId = null;
                if (name.startsWith(c + "_")) {
                    newId = new ResourceLocation(id.m_135827_(), name.substring((c + "_").length()));
                }
                if (name.endsWith("_" + c)) {
                    newId = new ResourceLocation(id.m_135827_(), name.substring(0, name.length() - ("_" + c).length()));
                }
                if (newId == null) continue;
                DyeColor dyeColor = colors.get(c);
                groupedByType.computeIfAbsent(newId, a -> new EnumMap(DyeColor.class)).put(dyeColor, b);
                continue block0;
            }
        }
        for (Map.Entry j : groupedByType.entrySet()) {
            EnumMap map = (EnumMap)j.getValue();
            ResourceLocation id = (ResourceLocation)j.getKey();
            if (id.m_135827_().equals("energeticsheep") || !map.keySet().containsAll(VANILLA_COLORS)) continue;
            ColoredSet<T> set = new ColoredSet<T>(id, map, registry);
            colorSetMap.put(id.toString(), set);
            for (Map.Entry v : set.colorsToBlock.entrySet()) {
                BLOCK_TO_COLORS.put(v.getValue(), (Object)v.getKey());
                BLOCK_TO_TYPE.put(v.getValue(), (Object)id.toString());
            }
        }
    }

    @Nullable
    public static DyeColor getColor(Block block) {
        return (DyeColor)BLOCK_TO_COLORS.get((Object)block);
    }

    @Nullable
    public static DyeColor getColor(Item item) {
        return (DyeColor)BLOCK_TO_COLORS.get((Object)item);
    }

    @Nullable
    public static Item getColoredItem(String key, @Nullable DyeColor color) {
        ColoredSet<Item> set = BlocksColorInternal.getItemSet(key);
        if (set != null) {
            return set.with(color);
        }
        return null;
    }

    @Nullable
    public static Block getColoredBlock(String key, @Nullable DyeColor color) {
        ColoredSet<Block> set = BlocksColorInternal.getBlockSet(key);
        if (set != null) {
            return set.with(color);
        }
        return null;
    }

    public static Set<String> getBlockKeys() {
        return BLOCK_COLOR_SETS.keySet();
    }

    public static Set<String> getItemKeys() {
        return ITEM_COLOR_SETS.keySet();
    }

    @Nullable
    public static Block changeColor(Block old, @Nullable DyeColor newColor) {
        Block b;
        ColoredSet<Block> set;
        String key = BlocksColorInternal.getKey(old);
        if (key != null && (set = BlocksColorInternal.getBlockSet(key)) != null && (b = set.with(newColor)) != old) {
            return b;
        }
        return null;
    }

    @Nullable
    public static Item changeColor(Item old, @Nullable DyeColor newColor) {
        Item i;
        ColoredSet<Item> set;
        String key = BlocksColorInternal.getKey(old);
        if (key != null && (set = BlocksColorInternal.getItemSet(key)) != null && (i = set.with(newColor)) != old) {
            return i;
        }
        return null;
    }

    @Nullable
    public static String getKey(Block block) {
        return (String)BLOCK_TO_TYPE.get((Object)block);
    }

    @Nullable
    public static String getKey(Item item) {
        return (String)BLOCK_TO_TYPE.get((Object)item);
    }

    @Nullable
    private static ColoredSet<Block> getBlockSet(String key) {
        key = new ResourceLocation(key).toString();
        return BLOCK_COLOR_SETS.get(key);
    }

    @Nullable
    private static ColoredSet<Item> getItemSet(String key) {
        key = new ResourceLocation(key).toString();
        return ITEM_COLOR_SETS.get(key);
    }

    @Nullable
    public static HolderSet<Block> getBlockHolderSet(String key) {
        ColoredSet<Block> set = BlocksColorInternal.getBlockSet(key);
        if (set != null) {
            return set.makeHolderSet((Registry<Block>)Registry.f_122824_);
        }
        return null;
    }

    @Nullable
    public static HolderSet<Item> getItemHolderSet(String key) {
        ColoredSet<Item> set = BlocksColorInternal.getItemSet(key);
        if (set != null) {
            return set.makeHolderSet((Registry<Item>)Registry.f_122827_);
        }
        return null;
    }

    private static class ColoredSet<T> {
        private final ResourceLocation id;
        private final Map<DyeColor, T> colorsToBlock;
        private final T defaultBlock;

        private ColoredSet(ResourceLocation id, EnumMap<DyeColor, T> map, Registry<T> registry) {
            this(id, map, registry, null);
        }

        private ColoredSet(ResourceLocation id, EnumMap<DyeColor, T> map, Registry<T> registry, @Nullable T defBlock) {
            this.colorsToBlock = map;
            this.id = id;
            block0: for (DyeColor c : MODDED_COLORS) {
                String namespace = id.m_135827_();
                String path = id.m_135815_();
                String mod = "tinted";
                for (String s : new String[]{namespace + ":" + path + "_%s", namespace + ":%s_" + path, mod + ":" + path + "_%s", mod + ":%s_" + path}) {
                    Optional o = registry.m_6612_(new ResourceLocation(String.format(s, c.m_41065_())));
                    if (!o.isPresent()) continue;
                    this.colorsToBlock.put(c, o.get());
                    continue block0;
                }
            }
            this.defaultBlock = defBlock == null ? this.computeDefault(id, registry) : defBlock;
        }

        private T computeDefault(ResourceLocation id, Registry<T> registry) {
            if (id.m_135827_().equals("minecraft") && id.m_135815_().contains("stained_glass")) {
                id = new ResourceLocation(id.m_135815_().replace("stained_", ""));
            } else if (id.m_135827_().equals("quark")) {
                if (id.m_135815_().equals("rune")) {
                    id = new ResourceLocation("quark", "blank_rune");
                } else if (id.m_135815_().equals("shard")) {
                    id = new ResourceLocation("quark", "clear_shard");
                }
            } else if (id.equals((Object)new ResourceLocation("suppsquared:sack"))) {
                id = new ResourceLocation("supplementaries:sack");
            }
            ResourceLocation finalId = id;
            Optional o = registry.m_6612_(id);
            if (o.isEmpty()) {
                return (T)registry.m_6612_(new ResourceLocation(finalId.m_135815_())).orElseGet(() -> this.colorsToBlock.get(DyeColor.WHITE));
            }
            return o.get();
        }

        private HolderSet<T> makeHolderSet(Registry<T> registry) {
            Optional v = registry.m_203431_(TagKey.m_203882_((ResourceKey)registry.m_123023_(), (ResourceLocation)new ResourceLocation(this.id.m_135827_(), this.id.m_135815_() + "s")));
            if (v.isEmpty()) {
                v = registry.m_203431_(TagKey.m_203882_((ResourceKey)registry.m_123023_(), (ResourceLocation)new ResourceLocation(PlatformHelper.getPlatform().isForge() ? "forge" : "c", this.id.m_135815_() + "s")));
            }
            if (v.isPresent()) {
                HolderSet.Named tag = (HolderSet.Named)v.get();
                boolean success = true;
                for (T t2 : this.colorsToBlock.values()) {
                    if (tag.m_203333_(registry.m_206081_((ResourceKey)registry.m_7854_(t2).get()))) continue;
                    success = false;
                    break;
                }
                if (success) {
                    return tag;
                }
            }
            return HolderSet.m_205803_(t -> registry.m_206081_((ResourceKey)registry.m_7854_(t).get()), new ArrayList<T>(this.colorsToBlock.values()));
        }

        @Nullable
        private T with(@Nullable DyeColor newColor) {
            if (newColor != null && !this.colorsToBlock.containsKey(newColor)) {
                return null;
            }
            return this.colorsToBlock.getOrDefault(newColor, this.defaultBlock);
        }
    }
}

