/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.common.item;

import com.google.common.collect.Lists;
import com.teamabnormals.neapolitan.common.item.DrinkItem;
import com.teamabnormals.neapolitan.core.registry.NeapolitanItems;
import com.teamabnormals.neapolitan.core.registry.NeapolitanMobEffects;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MilkshakeItem
extends DrinkItem {
    private final MobEffectCategory effectType;

    public MilkshakeItem(MobEffectCategory effectType, Item.Properties builder) {
        super(builder);
        this.effectType = effectType;
    }

    @Override
    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entity) {
        this.handleEffects(entity);
        return super.m_5922_(stack, worldIn, entity);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (entity.f_19853_.f_46443_) {
            return InteractionResult.CONSUME;
        }
        entity.f_19853_.m_5594_(null, entity.m_20183_(), SoundEvents.f_12585_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverplayerentity = (ServerPlayer)player;
            CriteriaTriggers.f_10592_.m_23682_(serverplayerentity, stack);
            serverplayerentity.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
        if (entity.m_21124_((MobEffect)NeapolitanMobEffects.VANILLA_SCENT.get()) == null) {
            this.handleEffects(entity);
        }
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
            ItemStack itemstack = new ItemStack((ItemLike)Items.f_42590_);
            if (!player.m_150109_().m_36054_(itemstack)) {
                player.m_36176_(itemstack, false);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void handleEffects(LivingEntity user) {
        ArrayList effects = Lists.newArrayList((Iterable)user.m_21220_());
        if (this.getEffectType() != null) {
            for (MobEffectInstance effectInstance : effects) {
                MobEffect effect = effectInstance.m_19544_();
                if (effect.m_19483_() != this.getEffectType() && (this.getEffectType() != MobEffectCategory.HARMFUL || effect != MobEffects.f_19594_) && this.getEffectType() != MobEffectCategory.NEUTRAL) continue;
                user.m_21195_(effect);
            }
        } else {
            LivingEntity nearest = user.f_19853_.m_45963_(LivingEntity.class, TargetingConditions.f_26872_.m_26888_(living -> living != user && living.m_21124_((MobEffect)NeapolitanMobEffects.VANILLA_SCENT.get()) == null), user, user.m_20185_(), user.m_20186_(), user.m_20189_(), user.m_20191_().m_82377_(6.0, 2.0, 6.0));
            if (nearest != null) {
                ArrayList nearestEffects = Lists.newArrayList((Iterable)nearest.m_21220_());
                this.nerfEffects(effects);
                this.nerfEffects(nearestEffects);
                if (this == NeapolitanItems.BANANA_MILKSHAKE.get()) {
                    user.m_21219_();
                    nearest.m_21219_();
                    effects.forEach(arg_0 -> ((LivingEntity)nearest).m_7292_(arg_0));
                    nearestEffects.forEach(arg_0 -> ((LivingEntity)user).m_7292_(arg_0));
                } else if (this == NeapolitanItems.MINT_MILKSHAKE.get()) {
                    nearest.m_21219_();
                    nearestEffects.forEach(arg_0 -> ((LivingEntity)user).m_7292_(arg_0));
                } else if (this == NeapolitanItems.ADZUKI_MILKSHAKE.get()) {
                    user.m_21219_();
                    effects.forEach(arg_0 -> ((LivingEntity)nearest).m_7292_(arg_0));
                }
            }
        }
    }

    private void nerfEffects(List<MobEffectInstance> effects) {
        ArrayList toNerf = Lists.newArrayList();
        effects.forEach(effect -> {
            if (effect.m_19557_() > 32766) {
                toNerf.add(effect);
            }
        });
        if (toNerf.isEmpty()) {
            return;
        }
        effects.removeAll(toNerf);
        toNerf.forEach(effect -> effects.add(new MobEffectInstance(effect.m_19544_(), 32766, effect.m_19564_(), effect.m_19571_(), effect.m_19572_(), effect.m_19575_())));
    }

    public int m_8105_(ItemStack stack) {
        return 40;
    }

    @Override
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public SoundEvent m_6023_() {
        return SoundEvents.f_11970_;
    }

    public SoundEvent m_6061_() {
        return SoundEvents.f_11970_;
    }

    public MobEffectCategory getEffectType() {
        return this.effectType;
    }
}

