/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.core;

import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import com.teamabnormals.neapolitan.client.model.BananaPeelModel;
import com.teamabnormals.neapolitan.client.model.ChimpanzeeModel;
import com.teamabnormals.neapolitan.client.renderer.entity.BananaPeelRenderer;
import com.teamabnormals.neapolitan.client.renderer.entity.BananarrowRenderer;
import com.teamabnormals.neapolitan.client.renderer.entity.ChimpanzeeRenderer;
import com.teamabnormals.neapolitan.client.renderer.entity.PlantainSpiderRenderer;
import com.teamabnormals.neapolitan.core.NeapolitanConfig;
import com.teamabnormals.neapolitan.core.data.client.NeapolitanBlockStateProvider;
import com.teamabnormals.neapolitan.core.data.server.NeapolitanLootTableProvider;
import com.teamabnormals.neapolitan.core.data.server.modifiers.NeapolitanAdvancementModifierProvider;
import com.teamabnormals.neapolitan.core.data.server.modifiers.NeapolitanBiomeModifierProvider;
import com.teamabnormals.neapolitan.core.data.server.modifiers.NeapolitanLootModifierProvider;
import com.teamabnormals.neapolitan.core.data.server.tags.NeapolitanBannerPatternTagsProvider;
import com.teamabnormals.neapolitan.core.data.server.tags.NeapolitanBiomeTagsProvider;
import com.teamabnormals.neapolitan.core.data.server.tags.NeapolitanBlockTagsProvider;
import com.teamabnormals.neapolitan.core.data.server.tags.NeapolitanEntityTypeTagsProvider;
import com.teamabnormals.neapolitan.core.data.server.tags.NeapolitanItemTagsProvider;
import com.teamabnormals.neapolitan.core.data.server.tags.NeapolitanMobEffectTagsProvider;
import com.teamabnormals.neapolitan.core.other.NeapolitanCompat;
import com.teamabnormals.neapolitan.core.other.NeapolitanModelLayers;
import com.teamabnormals.neapolitan.core.registry.NeapolitanBannerPatterns;
import com.teamabnormals.neapolitan.core.registry.NeapolitanEntityTypes;
import com.teamabnormals.neapolitan.core.registry.NeapolitanFeatures;
import com.teamabnormals.neapolitan.core.registry.NeapolitanMobEffects;
import com.teamabnormals.neapolitan.core.registry.NeapolitanPaintingVariants;
import com.teamabnormals.neapolitan.core.registry.NeapolitanParticleTypes;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="neapolitan")
@Mod.EventBusSubscriber(modid="neapolitan")
public class Neapolitan {
    public static final String MOD_ID = "neapolitan";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("neapolitan");

    public Neapolitan() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        MinecraftForge.EVENT_BUS.register((Object)this);
        ForgeMod.enableMilkFluid();
        REGISTRY_HELPER.register(bus);
        NeapolitanMobEffects.MOB_EFFECTS.register(bus);
        NeapolitanFeatures.FEATURES.register(bus);
        NeapolitanFeatures.NeapolitanConfiguredFeatures.CONFIGURED_FEATURES.register(bus);
        NeapolitanFeatures.NeapolitanPlacedFeatures.PLACED_FEATURES.register(bus);
        NeapolitanPaintingVariants.PAINTING_VARIANTS.register(bus);
        NeapolitanBannerPatterns.BANNER_PATTERNS.register(bus);
        NeapolitanParticleTypes.PARTICLE_TYPES.register(bus);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            bus.addListener(this::registerLayerDefinitions);
            bus.addListener(this::registerRenderers);
        });
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)NeapolitanConfig.COMMON_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            NeapolitanCompat.transformCookies();
            NeapolitanCompat.registerCompat();
            NeapolitanEntityTypes.registerEntitySpawns();
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(NeapolitanCompat::registerRenderLayers);
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        boolean includeServer = event.includeServer();
        NeapolitanBlockTagsProvider blockTagsProvider = new NeapolitanBlockTagsProvider(generator, existingFileHelper);
        generator.m_236039_(includeServer, (DataProvider)blockTagsProvider);
        generator.m_236039_(includeServer, (DataProvider)new NeapolitanItemTagsProvider(generator, blockTagsProvider, existingFileHelper));
        generator.m_236039_(includeServer, (DataProvider)new NeapolitanEntityTypeTagsProvider(generator, existingFileHelper));
        generator.m_236039_(includeServer, (DataProvider)new NeapolitanBannerPatternTagsProvider(generator, existingFileHelper));
        generator.m_236039_(includeServer, (DataProvider)new NeapolitanBiomeTagsProvider(generator, existingFileHelper));
        generator.m_236039_(includeServer, (DataProvider)new NeapolitanMobEffectTagsProvider(generator, existingFileHelper));
        generator.m_236039_(includeServer, (DataProvider)new NeapolitanLootTableProvider(generator));
        generator.m_236039_(includeServer, (DataProvider)new NeapolitanLootModifierProvider(generator));
        generator.m_236039_(includeServer, (DataProvider)new NeapolitanAdvancementModifierProvider(generator));
        generator.m_236039_(includeServer, NeapolitanBiomeModifierProvider.create(generator, existingFileHelper));
        boolean includeClient = event.includeClient();
        generator.m_236039_(includeClient, (DataProvider)new NeapolitanBlockStateProvider(generator, existingFileHelper));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(NeapolitanModelLayers.BANANA_PEEL, BananaPeelModel::createBodyLayer);
        event.registerLayerDefinition(NeapolitanModelLayers.CHIMPANZEE, () -> ChimpanzeeModel.createBodyLayer(0.0f, false, false));
        event.registerLayerDefinition(NeapolitanModelLayers.CHIMPANZEE_INNER_ARMOR, () -> ChimpanzeeModel.createBodyLayer(0.5f, true, true));
        event.registerLayerDefinition(NeapolitanModelLayers.CHIMPANZEE_OUTER_ARMOR, () -> ChimpanzeeModel.createBodyLayer(1.0f, true, false));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)NeapolitanEntityTypes.CHIMPANZEE.get(), ChimpanzeeRenderer::new);
        event.registerEntityRenderer((EntityType)NeapolitanEntityTypes.PLANTAIN_SPIDER.get(), PlantainSpiderRenderer::new);
        event.registerEntityRenderer((EntityType)NeapolitanEntityTypes.BANANA_PEEL.get(), BananaPeelRenderer::new);
        event.registerEntityRenderer((EntityType)NeapolitanEntityTypes.BANANARROW.get(), BananarrowRenderer::new);
    }
}

