/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.core.other;

import com.teamabnormals.blueprint.core.other.tags.BlueprintEntityTypeTags;
import com.teamabnormals.blueprint.core.util.TradeUtil;
import com.teamabnormals.neapolitan.common.entity.animal.Chimpanzee;
import com.teamabnormals.neapolitan.common.entity.monster.PlantainSpider;
import com.teamabnormals.neapolitan.core.NeapolitanConfig;
import com.teamabnormals.neapolitan.core.other.NeapolitanCriteriaTriggers;
import com.teamabnormals.neapolitan.core.other.tags.NeapolitanBiomeTags;
import com.teamabnormals.neapolitan.core.other.tags.NeapolitanEntityTypeTags;
import com.teamabnormals.neapolitan.core.other.tags.NeapolitanMobEffectTags;
import com.teamabnormals.neapolitan.core.registry.NeapolitanBlocks;
import com.teamabnormals.neapolitan.core.registry.NeapolitanEntityTypes;
import com.teamabnormals.neapolitan.core.registry.NeapolitanItems;
import com.teamabnormals.neapolitan.core.registry.NeapolitanMobEffects;
import com.teamabnormals.neapolitan.core.registry.NeapolitanParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

@Mod.EventBusSubscriber(modid="neapolitan")
public class NeapolitanEvents {
    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Monster) {
            Monster mobEntity = (Monster)entity;
            if (!entity.m_6095_().m_204039_(NeapolitanEntityTypeTags.UNAFFECTED_BY_HARMONY)) {
                mobEntity.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)mobEntity, Player.class, 12.0f, 1.0, 1.0, player -> player.m_21124_((MobEffect)NeapolitanMobEffects.HARMONY.get()) != null));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_6095_().m_204039_(BlueprintEntityTypeTags.MILKABLE)) {
            Level level = event.getEntity().m_9236_();
            BlockPos entityPos = entity.m_20183_();
            BlockPos dripstonePos = entity.m_20097_().m_7495_();
            RandomSource random = level.f_46441_;
            if (level.m_46467_() % 60L == 0L && PointedDripstoneBlock.m_154238_((BlockState)level.m_8055_(dripstonePos))) {
                Vec3 vec3 = level.m_8055_(entityPos).m_60824_((BlockGetter)level, entityPos);
                double d1 = (double)entityPos.m_123341_() + 0.5 + vec3.f_82479_ + NeapolitanEvents.makeNegativeRandomly(random.m_188501_() * 0.25f, random);
                double d2 = (float)entityPos.m_123342_() + entity.m_20206_() / 2.0f;
                double d3 = (double)entityPos.m_123343_() + 0.5 + vec3.f_82481_ + NeapolitanEvents.makeNegativeRandomly(random.m_188501_() * 0.25f, random);
                level.m_7106_((ParticleOptions)NeapolitanParticleTypes.DRIPPING_DRIPSTONE_MILK.get(), d1, d2, d3, 0.0, 0.0, 0.0);
            }
        }
    }

    public static double makeNegativeRandomly(double value, RandomSource rand) {
        return rand.m_188499_() ? -value : value;
    }

    @SubscribeEvent
    public static void onLivingSpawn(LivingSpawnEvent.CheckSpawn event) {
        Mob entity = event.getEntity();
        LevelAccessor level = event.getLevel();
        Holder biome = level.m_204166_(entity.m_20183_());
        if (event.getResult() != Event.Result.DENY && level.m_213780_().m_188503_(4) != 0) {
            boolean validSpawn;
            boolean bl = validSpawn = event.getSpawnReason() == MobSpawnType.NATURAL || event.getSpawnReason() == MobSpawnType.CHUNK_GENERATION || event.getSpawnReason() == MobSpawnType.MOB_SUMMONED;
            if (validSpawn && biome.m_203656_(NeapolitanBiomeTags.HAS_PLANTAIN_SPIDER) && entity.m_6095_().m_204039_(NeapolitanEntityTypeTags.PLANTAIN_SPIDERS_CAN_REPLACE) && event.getY() > 60.0) {
                Spider spider = (Spider)entity;
                PlantainSpider plantainSpider = (PlantainSpider)((EntityType)NeapolitanEntityTypes.PLANTAIN_SPIDER.get()).m_20615_((Level)level);
                if (plantainSpider != null) {
                    plantainSpider.m_20359_((Entity)spider);
                    level.m_7967_((Entity)plantainSpider);
                    entity.m_146870_();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        InteractionResult result;
        Level world = event.getLevel();
        ItemStack stack = event.getItemStack();
        Entity entity = event.getTarget();
        InteractionHand hand = event.getHand();
        Player player = event.getEntity();
        if (((Boolean)NeapolitanConfig.COMMON.milkingWithGlassBottles.get()).booleanValue() && entity.m_6095_().m_204039_(BlueprintEntityTypeTags.MILKABLE)) {
            boolean notChild;
            boolean bl = notChild = !(entity instanceof LivingEntity) || !((LivingEntity)entity).m_6162_();
            if (stack.m_41720_() == Items.f_42590_ && notChild) {
                player.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
                ItemStack newStack = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)((Item)NeapolitanItems.MILK_BOTTLE.get()).m_7968_());
                player.m_21008_(hand, newStack);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.m_19078_((boolean)world.m_5776_()));
            }
        }
        if (entity instanceof LivingEntity && !entity.m_6095_().m_204039_(NeapolitanEntityTypeTags.UNAFFECTED_BY_SLIPPING) && stack.m_41720_() == NeapolitanItems.BANANA_BUNCH.get() && (result = stack.m_41647_(player, (LivingEntity)entity, hand)).m_19077_()) {
            event.setCanceled(true);
            event.setCancellationResult(result);
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        MobEffectInstance berserking;
        LivingEntity attacker;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity && (attacker = (LivingEntity)entity).m_21124_((MobEffect)NeapolitanMobEffects.BERSERKING.get()) != null && (berserking = attacker.m_21124_((MobEffect)NeapolitanMobEffects.BERSERKING.get())).m_19564_() < 9) {
            MobEffectInstance upgrade = new MobEffectInstance(berserking.m_19544_(), berserking.m_19557_(), berserking.m_19564_() + 1, berserking.m_19571_(), berserking.m_19572_(), berserking.m_19575_());
            attacker.m_6234_((MobEffect)NeapolitanMobEffects.BERSERKING.get());
            attacker.m_7292_(upgrade);
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        LivingEntity source = event.getExplosion().m_46079_();
        if (source != null && source.m_6095_().m_204039_(NeapolitanEntityTypeTags.EXPLOSION_HEALS_IN_STRAWBERRY) && event.getLevel().m_8055_(source.m_20183_()).m_60734_() == NeapolitanBlocks.STRAWBERRY_BUSH.get()) {
            for (Entity entity : event.getAffectedEntities()) {
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    livingEntity.m_5634_(5.0f);
                }
                if (!(entity instanceof ServerPlayer)) continue;
                NeapolitanCriteriaTriggers.CREEPER_HEAL.trigger((ServerPlayer)entity);
            }
            event.getAffectedEntities().clear();
            event.getAffectedBlocks().clear();
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        EntityHitResult entity;
        Entity entity2;
        if (event.getProjectile().m_6095_().m_204039_(NeapolitanEntityTypeTags.MUDDY_PROJECTILES) && event.getRayTraceResult().m_6662_() == HitResult.Type.ENTITY && (entity2 = (entity = (EntityHitResult)event.getRayTraceResult()).m_82443_()) instanceof Chimpanzee) {
            Chimpanzee chimpanzee = (Chimpanzee)entity2;
            chimpanzee.setDirtiness(12000);
        }
    }

    @SubscribeEvent
    public static void onPotionAdded(MobEffectEvent.Applicable event) {
        ITagManager mobEffectTags;
        MobEffect effect = event.getEffectInstance().m_19544_();
        LivingEntity entity = event.getEntity();
        if (entity.m_21124_((MobEffect)NeapolitanMobEffects.VANILLA_SCENT.get()) != null && (mobEffectTags = ForgeRegistries.MOB_EFFECTS.tags()) != null && !mobEffectTags.getTag(NeapolitanMobEffectTags.UNAFFECTED_BY_VANILLA_SCENT).contains((Object)effect)) {
            event.setResult(Event.Result.DENY);
        }
        if (effect == NeapolitanMobEffects.SUGAR_RUSH.get() && !entity.f_19853_.f_46443_) {
            entity.getPersistentData().m_128405_("SugarRushDuration", event.getEffectInstance().m_19557_());
        }
    }

    @SubscribeEvent
    public static void onVillagerTrades(VillagerTradesEvent event) {
        if (event.getType().equals((Object)VillagerProfession.f_35590_)) {
            TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (int)2, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade((Item)NeapolitanItems.STRAWBERRIES.get(), 24, 1, 16, 2)});
            TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (int)3, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade((Item)NeapolitanItems.BANANA.get(), 8, 1, 12, 10), new TradeUtil.BlueprintTrade(3, (Item)NeapolitanItems.STRAWBERRY_SCONES.get(), 12, 12, 10)});
            TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (int)4, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(3, (Item)NeapolitanItems.VANILLA_CAKE.get(), 1, 12, 15), new TradeUtil.BlueprintTrade(3, (Item)NeapolitanItems.CHOCOLATE_CAKE.get(), 1, 12, 15), new TradeUtil.BlueprintTrade(3, (Item)NeapolitanItems.STRAWBERRY_CAKE.get(), 1, 12, 15), new TradeUtil.BlueprintTrade(3, (Item)NeapolitanItems.BANANA_CAKE.get(), 1, 12, 15), new TradeUtil.BlueprintTrade(3, (Item)NeapolitanItems.MINT_CAKE.get(), 1, 12, 15)});
        }
        TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (VillagerProfession)VillagerProfession.f_35587_, (int)5, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade((Item)NeapolitanItems.MINT_LEAVES.get(), 10, 1, 12, 30)});
        TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (VillagerProfession)VillagerProfession.f_35592_, (int)4, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(1, (Item)NeapolitanItems.BANANARROW.get(), 4, 12, 15)});
    }

    @SubscribeEvent
    public static void onWandererTradesEvent(WandererTradesEvent event) {
        TradeUtil.addWandererTrades((WandererTradesEvent)event, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(1, (Item)NeapolitanItems.STRAWBERRY_PIPS.get(), 1, 12, 1), new TradeUtil.BlueprintTrade(2, (Item)NeapolitanItems.VANILLA_PODS.get(), 1, 5, 1), new TradeUtil.BlueprintTrade(2, ((Block)NeapolitanBlocks.BANANA_FROND.get()).m_5456_(), 1, 5, 1), new TradeUtil.BlueprintTrade(2, (Item)NeapolitanItems.MINT_SPROUT.get(), 1, 5, 1), new TradeUtil.BlueprintTrade(2, (Item)NeapolitanItems.ADZUKI_BEANS.get(), 1, 5, 1)});
        TradeUtil.addRareWandererTrades((WandererTradesEvent)event, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(1, (Item)NeapolitanItems.WHITE_STRAWBERRIES.get(), 1, 8, 1), new TradeUtil.BlueprintTrade(3, (Item)NeapolitanItems.MAGIC_BEANS.get(), 1, 6, 1)});
    }
}

