/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.core.registry;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.teamabnormals.neapolitan.common.levelgen.feature.AdzukiSproutsFeature;
import com.teamabnormals.neapolitan.common.levelgen.feature.BananaPlantFeature;
import com.teamabnormals.neapolitan.common.levelgen.feature.MintPondFeature;
import com.teamabnormals.neapolitan.common.levelgen.feature.StrawberryBushFeature;
import com.teamabnormals.neapolitan.common.levelgen.feature.VanillaPatchFeature;
import com.teamabnormals.neapolitan.core.registry.NeapolitanBlocks;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class NeapolitanFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"neapolitan");
    public static final RegistryObject<Feature<SimpleBlockConfiguration>> STRAWBERRY_BUSH = FEATURES.register("strawberry_bush", () -> new StrawberryBushFeature((Codec<SimpleBlockConfiguration>)SimpleBlockConfiguration.f_68068_));
    public static final RegistryObject<Feature<RandomPatchConfiguration>> VANILLA_VINE_PATCH = FEATURES.register("vanilla_patch", () -> new VanillaPatchFeature((Codec<RandomPatchConfiguration>)RandomPatchConfiguration.f_67902_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> BANANA_PLANT = FEATURES.register("banana_plant", () -> new BananaPlantFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<SimpleBlockConfiguration>> ADZUKI_SPROUTS = FEATURES.register("adzuki_sprouts", () -> new AdzukiSproutsFeature((Codec<SimpleBlockConfiguration>)SimpleBlockConfiguration.f_68068_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> MINT_POND = FEATURES.register("mind_pond", () -> new MintPondFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));

    public static final class NeapolitanPlacedFeatures {
        public static final DeferredRegister<PlacedFeature> PLACED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_194567_, (String)"neapolitan");
        public static final RegistryObject<PlacedFeature> PATCH_STRAWBERRY_BUSH = NeapolitanPlacedFeatures.register("patch_strawberry_bush", NeapolitanConfiguredFeatures.PATCH_STRAWBERRY_BUSH, new PlacementModifier[]{RarityFilter.m_191900_((int)64), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_VANILLA_VINE = NeapolitanPlacedFeatures.register("patch_vanilla_vine", NeapolitanConfiguredFeatures.PATCH_VANILLA_VINE, new PlacementModifier[]{RarityFilter.m_191900_((int)64), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_ADZUKI_SPROUTS = NeapolitanPlacedFeatures.register("patch_adzuki_sprouts", NeapolitanConfiguredFeatures.PATCH_ADZUKI_SPROUTS, new PlacementModifier[]{RarityFilter.m_191900_((int)64), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> MINT_POND = NeapolitanPlacedFeatures.register("mint_pond", NeapolitanConfiguredFeatures.MINT_POND, new PlacementModifier[]{RarityFilter.m_191900_((int)8), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> BANANA_PLANT_BEACH = NeapolitanPlacedFeatures.register("banana_plant_beach", NeapolitanConfiguredFeatures.BANANA_PLANT, new PlacementModifier[]{PlacementUtils.m_195364_((int)0, (float)0.05f, (int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> BANANA_PLANT_JUNGLE = NeapolitanPlacedFeatures.register("banana_plant_jungle", NeapolitanConfiguredFeatures.BANANA_PLANT, new PlacementModifier[]{PlacementUtils.m_195364_((int)0, (float)0.25f, (int)3), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> BANANA_PLANT_RARE = NeapolitanPlacedFeatures.register("banana_plant_rare", NeapolitanConfiguredFeatures.BANANA_PLANT, new PlacementModifier[]{PlacementUtils.m_195364_((int)0, (float)0.25f, (int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> BANANA_PLANT_VERY_RARE = NeapolitanPlacedFeatures.register("banana_plant_very_rare", NeapolitanConfiguredFeatures.BANANA_PLANT, new PlacementModifier[]{PlacementUtils.m_195364_((int)0, (float)0.125f, (int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});

        private static RegistryObject<PlacedFeature> register(String name, RegistryObject<? extends ConfiguredFeature<?, ?>> feature, PlacementModifier ... placementModifiers) {
            return PLACED_FEATURES.register(name, () -> new PlacedFeature((Holder)feature.getHolder().get(), (List)ImmutableList.copyOf((Object[])placementModifiers)));
        }
    }

    public static final class NeapolitanConfiguredFeatures {
        public static final DeferredRegister<ConfiguredFeature<?, ?>> CONFIGURED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_122881_, (String)"neapolitan");
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_STRAWBERRY_BUSH = NeapolitanConfiguredFeatures.register("patch_strawberry_bush", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)new RandomPatchConfiguration(512, 5, 3, PlacementUtils.m_206498_((Feature)((Feature)STRAWBERRY_BUSH.get()), (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((Block)NeapolitanBlocks.STRAWBERRY_BUSH.get()).m_49966_())), (BlockPredicate)NeapolitanConfiguredFeatures.simplePatchPredicate(List.of(Blocks.f_50440_))))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_VANILLA_VINE = NeapolitanConfiguredFeatures.register("patch_vanilla_vine", () -> new ConfiguredFeature((Feature)VANILLA_VINE_PATCH.get(), (FeatureConfiguration)new RandomPatchConfiguration(64, 7, 3, PlacementUtils.m_206498_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((Block)NeapolitanBlocks.VANILLA_VINE.get()).m_49966_())), (BlockPredicate)BlockPredicate.m_190404_((BlockPredicate)BlockPredicate.m_190419_(), (BlockPredicate)BlockPredicate.f_190393_)))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_ADZUKI_SPROUTS = NeapolitanConfiguredFeatures.register("patch_adzuki_sprouts", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)new RandomPatchConfiguration(256, 3, 2, PlacementUtils.m_206498_((Feature)((Feature)ADZUKI_SPROUTS.get()), (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((Block)NeapolitanBlocks.ADZUKI_SPROUTS.get()).m_49966_())), (BlockPredicate)NeapolitanConfiguredFeatures.simplePatchPredicate(List.of(Blocks.f_50440_))))));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> MINT_POND = NeapolitanConfiguredFeatures.register("mint_pond", () -> new ConfiguredFeature((Feature)MINT_POND.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> BANANA_PLANT = NeapolitanConfiguredFeatures.register("banana_plant", () -> new ConfiguredFeature((Feature)BANANA_PLANT.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));

        private static <FC extends FeatureConfiguration, F extends Feature<FC>> RegistryObject<ConfiguredFeature<FC, ?>> register(String name, Supplier<ConfiguredFeature<FC, F>> feature) {
            return CONFIGURED_FEATURES.register(name, feature);
        }

        private static BlockPredicate simplePatchPredicate(List<Block> matchBlocks) {
            BlockPredicate blockpredicate = !matchBlocks.isEmpty() ? BlockPredicate.m_190404_((BlockPredicate)BlockPredicate.f_190393_, (BlockPredicate)BlockPredicate.m_224771_((Vec3i)Direction.DOWN.m_122436_(), matchBlocks)) : BlockPredicate.f_190393_;
            return blockpredicate;
        }
    }
}

