/*
 * Decompiled with CFR 0.152.
 */
package nomadictents;

import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import nomadictents.block.FrameBlock;
import nomadictents.block.IndluWallBlock;
import nomadictents.block.QuarterTentBlock;
import nomadictents.block.ShamiyanaWallBlock;
import nomadictents.block.TentBlock;
import nomadictents.block.TentDoorBlock;
import nomadictents.block.TepeeBlock;
import nomadictents.block.YurtRoofBlock;
import nomadictents.block.YurtWallBlock;
import nomadictents.dimension.EmptyChunkGenerator;
import nomadictents.item.MalletItem;
import nomadictents.item.TentItem;
import nomadictents.item.TentShovelItem;
import nomadictents.recipe.TentColorRecipe;
import nomadictents.recipe.TentLayerRecipe;
import nomadictents.recipe.TentSizeRecipe;
import nomadictents.structure.LocStructureProcessor;
import nomadictents.structure.ShamiyanaStructureProcessor;
import nomadictents.structure.TentPlacer;
import nomadictents.structure.TepeeStructureProcessor;
import nomadictents.tileentity.TentDoorBlockEntity;
import nomadictents.util.TentSize;
import nomadictents.util.TentType;

public final class NTRegistry {
    public static final String MODID = "nomadictents";
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"nomadictents");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"nomadictents");
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"nomadictents");
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"nomadictents");
    public static final CreativeModeTab TAB = new CreativeModeTab("nomadictents"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)TINY_YURT.get());
        }
    };
    public static final RegistryObject<Block> YURT_WALL = BLOCKS.register("yurt_wall", () -> new YurtWallBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76282_, (MaterialColor)MaterialColor.f_76401_).m_60918_(SoundType.f_56745_)));
    public static final RegistryObject<Block> YURT_ROOF = BLOCKS.register("yurt_roof", () -> new YurtRoofBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76282_, (MaterialColor)MaterialColor.f_76415_).m_60918_(SoundType.f_56745_)));
    public static final RegistryObject<Block> BEDOUIN_WALL = BLOCKS.register("bedouin_wall", () -> new QuarterTentBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76282_, (MaterialColor)MaterialColor.f_76362_).m_60918_(SoundType.f_56745_)));
    public static final RegistryObject<Block> BEDOUIN_ROOF = BLOCKS.register("bedouin_roof", () -> new TentBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76282_, (MaterialColor)MaterialColor.f_76362_).m_60918_(SoundType.f_56745_)));
    public static final RegistryObject<Block> INDLU_WALL = BLOCKS.register("indlu_wall", () -> new IndluWallBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76282_, (MaterialColor)MaterialColor.f_76399_).m_60955_().m_60971_((b, r, p) -> false).m_60918_(SoundType.f_56740_)));
    public static final RegistryObject<Block> RIGID_DIRT = BLOCKS.register("rigid_dirt", () -> new TentBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76282_, (MaterialColor)MaterialColor.f_76408_).m_60918_(SoundType.f_56739_)));
    public static final RegistryObject<Block> DOOR_FRAME = NTRegistry.registerFrame("door_frame");
    public static final RegistryObject<Block> YURT_WALL_FRAME = NTRegistry.registerFrame("yurt_wall_frame");
    public static final RegistryObject<Block> YURT_ROOF_FRAME = NTRegistry.registerFrame("yurt_roof_frame");
    public static final RegistryObject<Block> TEPEE_WALL_FRAME = NTRegistry.registerFrame("tepee_wall_frame");
    public static final RegistryObject<Block> BEDOUIN_WALL_FRAME = NTRegistry.registerFrame("bedouin_wall_frame");
    public static final RegistryObject<Block> BEDOUIN_ROOF_FRAME = NTRegistry.registerFrame("bedouin_roof_frame");
    public static final RegistryObject<Block> INDLU_WALL_FRAME = NTRegistry.registerFrame("indlu_wall_frame");
    public static final RegistryObject<Block> SHAMIYANA_WALL_FRAME = NTRegistry.registerFrame("shamiyana_wall_frame");
    public static final RegistryObject<Block> BLANK_TEPEE_WALL = RegistryObject.create((ResourceLocation)new ResourceLocation("nomadictents", "blank_tepee_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS);
    public static final RegistryObject<Block> WHITE_SHAMIYANA_WALL = RegistryObject.create((ResourceLocation)new ResourceLocation("nomadictents", "white_shamiyana_wall"), (IForgeRegistry)ForgeRegistries.BLOCKS);
    public static final RegistryObject<Item> MALLET = ITEMS.register("mallet", () -> new MalletItem((Tier)Tiers.IRON, false, new Item.Properties().m_41491_(TAB)));
    public static final RegistryObject<Item> GOLDEN_MALLET = ITEMS.register("golden_mallet", () -> new MalletItem((Tier)Tiers.DIAMOND, true, new Item.Properties().m_41491_(TAB)));
    public static final RegistryObject<Item> TINY_YURT = RegistryObject.create((ResourceLocation)new ResourceLocation("nomadictents", "tiny_yurt"), (IForgeRegistry)ForgeRegistries.ITEMS);
    public static final RegistryObject<BlockEntityType<TentDoorBlockEntity>> TENT_BLOCK_ENTITY = BLOCK_ENTITIES.register("tent_door", () -> {
        HashSet<Block> doorBlocks = new HashSet<Block>();
        for (Map<TentType, Supplier<Block>> doorMap : TentPlacer.DOORS.values()) {
            for (Supplier<Block> supplier : doorMap.values()) {
                doorBlocks.add(supplier.get());
            }
        }
        return BlockEntityType.Builder.m_155273_(TentDoorBlockEntity::new, (Block[])doorBlocks.toArray(new Block[0])).m_58966_(null);
    });
    public static final RegistryObject<TentSizeRecipe.Serializer> TENT_SIZE_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register("tent_size", () -> new TentSizeRecipe.Serializer());
    public static final RegistryObject<TentLayerRecipe.Serializer> TENT_LAYER_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register("tent_layer", () -> new TentLayerRecipe.Serializer());
    public static final RegistryObject<TentColorRecipe.Serializer> TENT_COLOR_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register("tent_color", () -> new TentColorRecipe.Serializer());
    public static StructureProcessorType<TepeeStructureProcessor> TEPEE_PROCESSOR;
    public static StructureProcessorType<ShamiyanaStructureProcessor> SHAMIYANA_PROCESSOR;
    public static StructureProcessorType<LocStructureProcessor> LOC_PROCESSOR;

    public static void register() {
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        BLOCK_ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        RECIPE_SERIALIZERS.register(FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(NTRegistry::onSetup);
        NTRegistry.registerBlocks();
        NTRegistry.registerItems();
    }

    private static void registerBlocks() {
        for (TepeeBlock.Type type : TepeeBlock.Type.values()) {
            BLOCKS.register(type.m_7912_() + "_tepee_wall", () -> new TepeeBlock(type, BlockBehaviour.Properties.m_60944_((Material)Material.f_76282_, (MaterialColor)MaterialColor.f_76372_).m_60918_(SoundType.f_56745_)));
        }
        for (TepeeBlock.Type type : DyeColor.values()) {
            BLOCKS.register(type.m_7912_() + "_shamiyana_wall", () -> NTRegistry.lambda$registerBlocks$1((DyeColor)type));
        }
        for (Enum enum_ : TentType.values()) {
            for (TentSize width : TentSize.values()) {
                BLOCKS.register(width.m_7912_() + "_" + ((TentType)enum_).m_7912_() + "_door", () -> new TentDoorBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76282_, (MaterialColor)MaterialColor.f_76401_).m_60918_(SoundType.f_56745_)));
            }
        }
    }

    private static void registerItems() {
        for (TentType tentType : TentType.values()) {
            for (TentSize width : TentSize.values()) {
                ITEMS.register(width.m_7912_() + "_" + tentType.m_7912_(), () -> new TentItem(tentType, width, new Item.Properties().m_41491_(TAB).m_41487_(1)));
            }
        }
        ITEMS.register("tent_canvas", () -> new Item(new Item.Properties().m_41491_(TAB)));
        ITEMS.register("yurt_section", () -> new Item(new Item.Properties().m_41491_(TAB)));
        ITEMS.register("tepee_section", () -> new Item(new Item.Properties().m_41491_(TAB)));
        ITEMS.register("indlu_section", () -> new Item(new Item.Properties().m_41491_(TAB)));
        ITEMS.register("bedouin_section", () -> new Item(new Item.Properties().m_41491_(TAB)));
        ITEMS.register("shamiyana_section", () -> new Item(new Item.Properties().m_41491_(TAB)));
        ITEMS.register("golden_crossbeams", () -> new Item(new Item.Properties().m_41491_(TAB)));
        ITEMS.register("obsidian_crossbeams", () -> new Item(new Item.Properties().m_41491_(TAB)));
        ITEMS.register("diamond_crossbeams", () -> new Item(new Item.Properties().m_41491_(TAB)));
        ITEMS.register("stone_tent_shovel", () -> new TentShovelItem(new Item.Properties().m_41491_(TAB)));
        ITEMS.register("iron_tent_shovel", () -> new TentShovelItem(new Item.Properties().m_41491_(TAB)));
        ITEMS.register("golden_tent_shovel", () -> new TentShovelItem(new Item.Properties().m_41491_(TAB)));
        ITEMS.register("obsidian_tent_shovel", () -> new TentShovelItem(new Item.Properties().m_41491_(TAB)));
        ITEMS.register("diamond_tent_shovel", () -> new TentShovelItem(new Item.Properties().m_41491_(TAB)));
        NTRegistry.registerItemBlock("rigid_dirt", RIGID_DIRT);
        NTRegistry.registerItemBlock("yurt_wall", YURT_WALL);
        NTRegistry.registerItemBlock("yurt_roof", YURT_ROOF);
        NTRegistry.registerItemBlock("bedouin_wall", BEDOUIN_WALL);
        NTRegistry.registerItemBlock("bedouin_roof", BEDOUIN_ROOF);
        NTRegistry.registerItemBlock("indlu_wall", INDLU_WALL);
        for (Enum enum_ : TepeeBlock.Type.values()) {
            NTRegistry.registerItemBlock(((TepeeBlock.Type)enum_).m_7912_() + "_tepee_wall", ((TepeeBlock.Type)enum_).getBlockSupplier());
        }
        for (Map.Entry entry : TentPlacer.SHAMIYANA_WALLS.entrySet()) {
            NTRegistry.registerItemBlock(((DyeColor)entry.getKey()).m_7912_() + "_shamiyana_wall", (Supplier)entry.getValue());
        }
        NTRegistry.registerItemBlock("door_frame", DOOR_FRAME, false);
        for (RegistryObject registryObject : TentPlacer.BLOCK_TO_FRAME.values()) {
            NTRegistry.registerItemBlock(registryObject.getId().m_135815_(), (Supplier<? extends Block>)registryObject, false);
        }
    }

    public static void onSetup(FMLCommonSetupEvent event) {
        TEPEE_PROCESSOR = StructureProcessorType.m_74476_((String)"nomadictents:tepee_processor", TepeeStructureProcessor.CODEC);
        SHAMIYANA_PROCESSOR = StructureProcessorType.m_74476_((String)"nomadictents:shamiyana_processor", ShamiyanaStructureProcessor.CODEC);
        LOC_PROCESSOR = StructureProcessorType.m_74476_((String)"nomadictents:loc_processor", LocStructureProcessor.CODEC);
        event.enqueueWork(() -> Registry.m_122965_((Registry)Registry.f_122890_, (ResourceLocation)new ResourceLocation(MODID, "empty"), EmptyChunkGenerator.CODEC));
    }

    private static RegistryObject<Block> registerFrame(String name) {
        return BLOCKS.register(name, () -> new FrameBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76282_, (MaterialColor)MaterialColor.f_76411_).m_60913_(-1.0f, 3600000.8f).m_60910_().m_222994_().m_60918_(SoundType.f_56736_)));
    }

    private static RegistryObject<BlockItem> registerItemBlock(String name, Supplier<? extends Block> blockSupplier) {
        return NTRegistry.registerItemBlock(name, blockSupplier, true);
    }

    private static RegistryObject<BlockItem> registerItemBlock(String name, Supplier<? extends Block> blockSupplier, boolean group) {
        return ITEMS.register(name, NTRegistry.itemBlock(blockSupplier, group));
    }

    private static Supplier<BlockItem> itemBlock(Supplier<? extends Block> blockSupplier, boolean group) {
        Item.Properties props = new Item.Properties();
        if (group) {
            props.m_41491_(TAB);
        }
        return () -> new BlockItem((Block)blockSupplier.get(), props);
    }

    private static /* synthetic */ ShamiyanaWallBlock lambda$registerBlocks$1(DyeColor color) {
        return new ShamiyanaWallBlock(color, BlockBehaviour.Properties.m_60944_((Material)Material.f_76282_, (MaterialColor)color.m_41069_()).m_60918_(SoundType.f_56745_));
    }
}

